/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils;

import com.artillexstudios.axgraves.libs.axapi.utils.Pair;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.MiniMessage;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class LegacyTranslator {
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([a-fA-F0-9]{6})>|<color:#([a-fA-F0-9])>|<c:#([a-fA-F0-9])>");
    private static final Pattern HEX_END_PATTERN = Pattern.compile("</[^/>]+>");
    private static final ObjectImmutableList<Pair<String, String>> minimessage = ObjectImmutableList.of((Object[])new Pair[]{Pair.of("<black>", "\u00a70"), Pair.of("<dark_blue>", "\u00a71"), Pair.of("<dark_green>", "\u00a72"), Pair.of("<dark_aqua>", "\u00a73"), Pair.of("<dark_red>", "\u00a74"), Pair.of("<dark_purple>", "\u00a75"), Pair.of("<gold>", "\u00a76"), Pair.of("<gray>", "\u00a77"), Pair.of("<dark_gray>", "\u00a78"), Pair.of("<blue>", "\u00a79"), Pair.of("<green>", "\u00a7a"), Pair.of("<aqua>", "\u00a7b"), Pair.of("<red>", "\u00a7c"), Pair.of("<light_purple>", "\u00a7d"), Pair.of("<yellow>", "\u00a7e"), Pair.of("<white>", "\u00a7f"), Pair.of("<reset>", "\u00a7r"), Pair.of("<br>", "\n"), Pair.of("<b>", "\u00a7l"), Pair.of("<bold>", "\u00a7l"), Pair.of("</b>", "\u00a7r"), Pair.of("</bold>", "\u00a7r"), Pair.of("<obf>", "\u00a7k"), Pair.of("</obf>", "\u00a7r"), Pair.of("<obfuscated>", "\u00a7k"), Pair.of("</obfuscated>", "\u00a7r"), Pair.of("<st>", "\u00a7m"), Pair.of("</st>", "\u00a7r"), Pair.of("<strikethrough>", "\u00a7m"), Pair.of("</strikethrough>", "\u00a7r"), Pair.of("<u>", "\u00a7n"), Pair.of("</u>", "\u00a7r"), Pair.of("<underlined>", "\u00a7n"), Pair.of("</underlined>", "\u00a7r"), Pair.of("<i>", "\u00a7o"), Pair.of("</i>", "\u00a7r"), Pair.of("<italic>", "\u00a7o"), Pair.of("</italic>", "\u00a7r")});

    public static String flatten(String string) {
        String toFormat = string;
        for (Pair stringStringPair : minimessage) {
            toFormat = toFormat.replace((CharSequence)stringStringPair.getKey(), (CharSequence)stringStringPair.getValue());
        }
        Matcher matcher = HEX_PATTERN.matcher(toFormat);
        toFormat = StringUtils.replaceAll(matcher, a -> {
            String group = a.group(1);
            return "&x&" + group.charAt(0) + "&" + group.charAt(1) + "&" + group.charAt(2) + "&" + group.charAt(3) + "&" + group.charAt(4) + "&" + group.charAt(5);
        });
        toFormat = HEX_END_PATTERN.matcher(toFormat).replaceAll("");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)toFormat);
    }

    public static String flatten(Component component) {
        return LegacyTranslator.flatten((String)MiniMessage.miniMessage().serialize(component));
    }
}

