/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils;

import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Cache;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.serializers.Serializer;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.serializer.gson.GsonComponentSerializer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public enum ComponentSerializer {
    INSTANCE;

    private final Serializer<Object, Component> serializer = NMSHandlers.getNmsHandler().componentSerializer();
    private final Cache<Component, Object> componentCache = Caffeine.newBuilder().maximumSize(200L).expireAfterAccess(Duration.ofSeconds(20L)).scheduler(Scheduler.systemScheduler()).build();
    private final Cache<Object, Component> vanillaCache = Caffeine.newBuilder().maximumSize(200L).expireAfterAccess(Duration.ofSeconds(20L)).scheduler(Scheduler.systemScheduler()).build();
    private final Cache<String, Component> gsonCache = Caffeine.newBuilder().maximumSize(200L).expireAfterAccess(Duration.ofSeconds(20L)).scheduler(Scheduler.systemScheduler()).build();

    public <T> T toVanilla(Component component) {
        return (T)this.componentCache.get((Object)component, this.serializer::deserialize);
    }

    public Component fromVanilla(Object object) {
        return (Component)this.vanillaCache.get(object, this.serializer::serialize);
    }

    public <T> List<T> toVanillaList(List<Component> components) {
        ArrayList<T> converted = new ArrayList<T>(components.size());
        for (int i = 0; i < components.size(); ++i) {
            Component component = components.get(i);
            converted.add(this.toVanilla(component));
        }
        return converted;
    }

    public List<Component> fromVanillaList(List<Object> objects) {
        ArrayList<Component> converted = new ArrayList<Component>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            Object component = objects.get(i);
            converted.add(this.fromVanilla(component));
        }
        return converted;
    }

    public ArrayList<Component> asAdventureFromJson(List<String> jsonStrings) {
        ArrayList<Component> adventures = new ArrayList<Component>(jsonStrings.size());
        for (String json : jsonStrings) {
            try {
                adventures.add((Component)GsonComponentSerializer.gson().deserialize(json));
            }
            catch (Exception exception) {
                adventures.add(Component.empty());
            }
        }
        return adventures;
    }

    public List<String> toGsonList(List<Component> list) {
        ArrayList<String> newList = new ArrayList<String>();
        for (Component component : list) {
            newList.add(this.toGson(component));
        }
        return newList;
    }

    public String toGson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public Component fromGson(String string) {
        return (Component)this.gsonCache.get((Object)string, s -> GsonComponentSerializer.gson().deserialize(s));
    }

    public List<Component> fromGsonList(List<String> list) {
        ArrayList<Component> newList = new ArrayList<Component>();
        for (String line : list) {
            newList.add(this.fromGson(line));
        }
        return newList;
    }
}

