/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.reflection;

import com.artillexstudios.axgraves.libs.axapi.reflection.UnsafeUtils;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class FastFieldAccessor {
    private static final Logger log = LoggerFactory.getLogger(FastFieldAccessor.class);
    private static final Unsafe unsafe = UnsafeUtils.INSTANCE.unsafe();
    private final Field field;
    private final long fieldOffset;

    public FastFieldAccessor(Field field) {
        this.field = field;
        this.fieldOffset = unsafe.objectFieldOffset(field);
    }

    public static FastFieldAccessor[] forClass(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Can't get FieldAccessor for null class!");
        Field[] declared = clazz.getDeclaredFields();
        FastFieldAccessor[] fieldAccessors = new FastFieldAccessor[declared.length];
        for (int i = 0; i < declared.length; ++i) {
            Field field = declared[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            fieldAccessors[i] = FastFieldAccessor.forField(field);
        }
        return fieldAccessors;
    }

    public static FastFieldAccessor forField(Field field) {
        Preconditions.checkNotNull((Object)field, (Object)"Can't get FieldAccessor for null field!");
        return new FastFieldAccessor(field);
    }

    public static FastFieldAccessor forClassField(Class<?> clazz, String field) {
        Preconditions.checkNotNull(clazz, (Object)"Can't get FieldAccessor for null class!");
        Preconditions.checkNotNull((Object)field, (Object)"Can't get FieldAccessor for null field!");
        Preconditions.checkArgument((!field.isEmpty() ? 1 : 0) != 0, (Object)"Can't get FieldAccessor for empty field!");
        try {
            Field f2 = clazz.getDeclaredField(field);
            return new FastFieldAccessor(f2);
        }
        catch (NoSuchFieldException exception) {
            log.error("An error occurred while creating new FastFieldAccessor for field {} of class {}! Fields of class: {}!", new Object[]{field, clazz.getName(), Arrays.stream(clazz.getDeclaredFields()).map(f -> f.getName() + "-" + f.getType()).collect(Collectors.joining(", ")), exception});
            throw new RuntimeException(exception);
        }
    }

    public static FastFieldAccessor forClassField(String clazz, String field) {
        try {
            return FastFieldAccessor.forClassField(Class.forName(clazz), field);
        }
        catch (ClassNotFoundException exception) {
            log.error("Could not find class named {}!", (Object)clazz, (Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public <T> void set(Object object, T value) {
        unsafe.putObject(object, this.fieldOffset, value);
    }

    public void setInt(Object object, int value) {
        unsafe.putInt(object, this.fieldOffset, value);
    }

    public void setLong(Object object, long value) {
        unsafe.putLong(object, this.fieldOffset, value);
    }

    public void setShort(Object object, short value) {
        unsafe.putShort(object, this.fieldOffset, value);
    }

    public void setDouble(Object object, double value) {
        unsafe.putDouble(object, this.fieldOffset, value);
    }

    public void setFloat(Object object, float value) {
        unsafe.putFloat(object, this.fieldOffset, value);
    }

    public void setBoolean(Object object, boolean value) {
        unsafe.putBoolean(object, this.fieldOffset, value);
    }

    public void setChar(Object object, char value) {
        unsafe.putChar(object, this.fieldOffset, value);
    }

    public void setByte(Object object, byte value) {
        unsafe.putByte(object, this.fieldOffset, value);
    }

    public <T> T get(Object object) {
        return (T)unsafe.getObject(object, this.fieldOffset);
    }

    public int getInt(Object object) {
        return unsafe.getInt(object, this.fieldOffset);
    }

    public short getShort(Object object) {
        return unsafe.getShort(object, this.fieldOffset);
    }

    public long getLong(Object object) {
        return unsafe.getLong(object, this.fieldOffset);
    }

    public double getDouble(Object object) {
        return unsafe.getDouble(object, this.fieldOffset);
    }

    public float getFloat(Object object) {
        return unsafe.getFloat(object, this.fieldOffset);
    }

    public boolean getBoolean(Object object) {
        return unsafe.getBoolean(object, this.fieldOffset);
    }

    public char getChar(Object object) {
        return unsafe.getChar(object, this.fieldOffset);
    }

    public byte getByte(Object object) {
        return unsafe.getByte(object, this.fieldOffset);
    }

    public void setAny(Object object, Object value) {
        if (this.field.getType() == Boolean.TYPE) {
            this.setBoolean(object, (Boolean)value);
        } else if (this.field.getType() == Byte.TYPE) {
            this.setByte(object, (Byte)value);
        } else if (this.field.getType() == Short.TYPE) {
            this.setShort(object, (Short)value);
        } else if (this.field.getType() == Character.TYPE) {
            this.setChar(object, ((Character)value).charValue());
        } else if (this.field.getType() == Integer.TYPE) {
            this.setInt(object, (Integer)value);
        } else if (this.field.getType() == Long.TYPE) {
            this.setLong(object, (Long)value);
        } else if (this.field.getType() == Float.TYPE) {
            this.setFloat(object, ((Float)value).floatValue());
        } else if (this.field.getType() == Double.TYPE) {
            this.setDouble(object, (Double)value);
        } else {
            this.set(object, value);
        }
    }

    public Object getAny(Object object) {
        if (this.field.getType() == Boolean.TYPE) {
            return this.getBoolean(object);
        }
        if (this.field.getType() == Byte.TYPE) {
            return this.getByte(object);
        }
        if (this.field.getType() == Short.TYPE) {
            return this.getShort(object);
        }
        if (this.field.getType() == Character.TYPE) {
            return Character.valueOf(this.getChar(object));
        }
        if (this.field.getType() == Integer.TYPE) {
            return this.getInt(object);
        }
        if (this.field.getType() == Long.TYPE) {
            return this.getLong(object);
        }
        if (this.field.getType() == Float.TYPE) {
            return Float.valueOf(this.getFloat(object));
        }
        if (this.field.getType() == Double.TYPE) {
            return this.getDouble(object);
        }
        return this.get(object);
    }

    public Field getField() {
        return this.field;
    }
}

