/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.packetentity.meta;

import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.AreaEffectCloudMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.ArmorStandMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.ItemEntityMeta;
import java.util.HashMap;
import java.util.function.Function;
import org.bukkit.entity.EntityType;

public class EntityMetaFactory {
    private static final HashMap<EntityType, Function<Metadata, EntityMeta>> entityMeta = new HashMap();

    public static void register(EntityType type, Function<Metadata, EntityMeta> generator) {
        entityMeta.put(type, generator);
    }

    public static EntityMeta getForType(EntityType type) {
        return entityMeta.getOrDefault(type, EntityMeta::new).apply(new Metadata());
    }

    static {
        EntityMetaFactory.register(EntityType.DROPPED_ITEM, ItemEntityMeta::new);
        EntityMetaFactory.register(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudMeta::new);
        EntityMetaFactory.register(EntityType.ARMOR_STAND, ArmorStandMeta::new);
    }
}

