/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_21_R3.utils;

import com.artillexstudios.axgraves.libs.axapi.utils.BossBar;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class BossBar
implements com.artillexstudios.axgraves.libs.axapi.utils.BossBar {
    private final UUID uuid = UUID.randomUUID();
    private final HashSet<BossBar.Flag> flags = new HashSet(4);
    private final Set<Player> viewers = Collections.newSetFromMap(new WeakHashMap());
    private final PacketPlayOutBoss removePacket = PacketPlayOutBoss.a((UUID)this.uuid);
    private Component title;
    private BossBar.Color color;
    private BossBar.Style style;
    private float progress;
    private PacketPlayOutBoss addPacket;
    private BossBattle event;

    public BossBar(Component title, float progress, BossBar.Color color, BossBar.Style style, BossBar.Flag ... flags) {
        Validate.inclusiveBetween((double)0.0, (double)1.0, (double)progress);
        this.title = title;
        this.progress = progress;
        this.color = color;
        this.style = style;
        this.flags.addAll(Arrays.asList(flags));
        this.event = new BossBattle(this, this.uuid, (IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(title), BossBattle.BarColor.a((String)color.getInternalName()), BossBattle.BarStyle.a((String)style.getInternalName())){};
        this.updateAddPacket();
    }

    @Override
    public void show(Player player) {
        if (this.viewers.add(player)) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.f.b((Packet)this.addPacket);
        }
    }

    @Override
    public void hide(Player player) {
        if (this.viewers.remove(player)) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.f.b((Packet)this.removePacket);
        }
    }

    @Override
    public void setStyle(BossBar.Style style) {
        this.style = style;
        this.event.a(BossBattle.BarStyle.a((String)this.style.getInternalName()));
        this.updateAddPacket();
        this.updateStyle();
    }

    @Override
    public void setColor(BossBar.Color color) {
        this.color = color;
        this.event.a(BossBattle.BarColor.a((String)this.color.getInternalName()));
        this.updateAddPacket();
        this.updateStyle();
    }

    @Override
    public void addFlags(BossBar.Flag ... flag) {
        this.flags.addAll(Arrays.asList(flag));
        this.updateAddPacket();
        this.updateFlags();
        for (BossBar.Flag flag1 : flag) {
            if (flag1 == BossBar.Flag.PLAY_BOSS_MUSIC) {
                this.event.b(true);
                continue;
            }
            if (flag1 == BossBar.Flag.CREATE_WORLD_FOG) {
                this.event.c(true);
                continue;
            }
            if (flag1 != BossBar.Flag.DARKEN_SCREEN) continue;
            this.event.a(true);
        }
    }

    @Override
    public void removeFlags(BossBar.Flag ... flag) {
        Arrays.asList(flag).forEach(this.flags::remove);
        for (BossBar.Flag flag1 : flag) {
            if (flag1 == BossBar.Flag.PLAY_BOSS_MUSIC) {
                this.event.b(false);
                continue;
            }
            if (flag1 == BossBar.Flag.CREATE_WORLD_FOG) {
                this.event.c(false);
                continue;
            }
            if (flag1 != BossBar.Flag.DARKEN_SCREEN) continue;
            this.event.a(false);
        }
        this.updateAddPacket();
        this.updateFlags();
    }

    @Override
    public Set<BossBar.Flag> getFlags() {
        return Set.copyOf(this.flags);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Component title) {
        this.title = title;
        this.event.a((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(title));
        this.updateAddPacket();
        this.updateTitle();
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        Validate.inclusiveBetween((double)0.0, (double)1.0, (double)progress);
        this.progress = progress;
        this.event.a(progress);
        this.updateAddPacket();
        this.updateProgress();
    }

    @Override
    public void remove() {
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.f.b((Packet)this.removePacket);
        }
    }

    private void updateTitle() {
        PacketPlayOutBoss titlePacket = PacketPlayOutBoss.c((BossBattle)this.event);
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.f.b((Packet)titlePacket);
        }
    }

    private void updateProgress() {
        PacketPlayOutBoss progressPacket = PacketPlayOutBoss.b((BossBattle)this.event);
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.f.b((Packet)progressPacket);
        }
    }

    private void updateStyle() {
        PacketPlayOutBoss progressPacket = PacketPlayOutBoss.d((BossBattle)this.event);
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.f.b((Packet)progressPacket);
        }
    }

    private void updateFlags() {
        PacketPlayOutBoss progressPacket = PacketPlayOutBoss.e((BossBattle)this.event);
        for (Player viewer : this.viewers) {
            EntityPlayer serverPlayer = ((CraftPlayer)viewer).getHandle();
            serverPlayer.f.b((Packet)progressPacket);
        }
    }

    private void updateAddPacket() {
        this.addPacket = PacketPlayOutBoss.a((BossBattle)this.event);
    }
}

