/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.packet;

import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.gui.SignInput;
import com.artillexstudios.axgraves.libs.axapi.items.PacketItemModifier;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastMethodInvoker;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketListener
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(PacketListener.class);
    private static final FastMethodInvoker methodInvoker = FastMethodInvoker.create("net.minecraft.network.protocol.game.PacketPlayInUseEntity", "a", PacketDataSerializer.class);
    private static final FastFieldAccessor merchantAccessor = FastFieldAccessor.forClassField(PacketPlayOutOpenWindowMerchant.class, "c");
    private final Player player;

    public PacketListener(Player player) {
        this.player = player;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        Object object = msg;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PacketPlayInUseEntity.class, PacketPlayInUpdateSign.class, PacketPlayInSetCreativeSlot.class}, (Object)object2, n)) {
            case 0: {
                PacketPlayInUseEntity packet = (PacketPlayInUseEntity)object2;
                if (AxPlugin.tracker == null) {
                    super.channelRead(ctx, msg);
                    return;
                }
                PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.buffer());
                methodInvoker.invoke(packet, byteBuf);
                int entityId = byteBuf.l();
                int actionType = byteBuf.l();
                EnumHand hand = null;
                Vector vector = null;
                boolean attack = false;
                if (actionType == 0) {
                    int interactionHand = byteBuf.l();
                    hand = interactionHand == 0 ? EnumHand.a : EnumHand.b;
                } else if (actionType == 1) {
                    attack = true;
                } else {
                    float x = byteBuf.readFloat();
                    float y = byteBuf.readFloat();
                    float z = byteBuf.readFloat();
                    vector = new Vector(x, y, z);
                    int interactionHand = byteBuf.l();
                    hand = interactionHand == 0 ? EnumHand.a : EnumHand.b;
                }
                byteBuf.release();
                PacketEntity entity = AxPlugin.tracker.getById(entityId);
                if (entity == null) break;
                PacketEntityInteractEvent event = new PacketEntityInteractEvent(this.player, entity, attack, vector, hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                Bukkit.getPluginManager().callEvent((Event)event);
                break;
            }
            case 1: {
                PacketPlayInUpdateSign updatePacket = (PacketPlayInUpdateSign)object2;
                SignInput signInput = SignInput.remove(this.player);
                if (signInput == null) {
                    super.channelRead(ctx, msg);
                    return;
                }
                signInput.getListener().accept(this.player, ComponentSerializer.INSTANCE.asAdventureFromJson(Arrays.asList(updatePacket.f())).toArray(new Component[0]));
                Scheduler.get().runAt(signInput.getLocation(), task -> {
                    CraftBlockData data = (CraftBlockData)signInput.getLocation().getBlock().getType().createBlockData();
                    BlockPosition pos = CraftLocation.toBlockPosition((Location)signInput.getLocation());
                    EntityPlayer serverPlayer = ((CraftPlayer)this.player).getHandle();
                    serverPlayer.c.b((Packet)new PacketPlayOutBlockChange(pos, data.getState()));
                });
                return;
            }
            case 2: {
                PacketPlayInSetCreativeSlot packet = (PacketPlayInSetCreativeSlot)object2;
                ItemStack item = packet.e();
                if (!PacketItemModifier.isListening()) break;
                PacketItemModifier.restore(new WrappedItemStack(item));
                break;
            }
        }
        super.channelRead(ctx, msg);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Object object = msg;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PacketPlayOutSetSlot.class, PacketPlayOutWindowItems.class, PacketPlayOutEntityEquipment.class, PacketPlayOutEntityMetadata.class, ClientboundBundlePacket.class, PacketPlayOutOpenWindowMerchant.class}, (Object)object, n)) {
            case 0: {
                PacketPlayOutSetSlot packet = (PacketPlayOutSetSlot)object;
                if (PacketItemModifier.isListening()) {
                    PacketItemModifier.callModify(new WrappedItemStack(packet.f()), this.player, PacketItemModifier.Context.SET_SLOT);
                }
                super.write(ctx, (Object)packet, promise);
                return;
            }
            case 1: {
                PacketPlayOutWindowItems packet = (PacketPlayOutWindowItems)object;
                if (PacketItemModifier.isListening()) {
                    PacketItemModifier.callModify(new WrappedItemStack(packet.f()), this.player, PacketItemModifier.Context.SET_CONTENTS);
                    for (ItemStack item : packet.e()) {
                        PacketItemModifier.callModify(new WrappedItemStack(item), this.player, PacketItemModifier.Context.SET_CONTENTS);
                    }
                }
                super.write(ctx, (Object)packet, promise);
                return;
            }
            case 2: {
                PacketPlayOutEntityEquipment packet = (PacketPlayOutEntityEquipment)object;
                if (!PacketItemModifier.isListening()) {
                    super.write(ctx, msg, promise);
                    return;
                }
                ArrayList<Pair> items = new ArrayList<Pair>();
                Iterator iterator = packet.e().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        PacketPlayOutEntityEquipment newEquipmentPacket = new PacketPlayOutEntityEquipment(packet.b(), items);
                        super.write(ctx, (Object)newEquipmentPacket, promise);
                        return;
                    }
                    Pair slot = (Pair)iterator.next();
                    ItemStack second23332 = (ItemStack)slot.getSecond();
                    if (second23332 == null) {
                        items.add(Pair.of((Object)((EnumItemSlot)slot.getFirst()), (Object)ItemStack.l));
                        continue;
                    }
                    ItemStack itemStack = second23332.s();
                    PacketItemModifier.callModify(new WrappedItemStack(itemStack), this.player, PacketItemModifier.Context.EQUIPMENT);
                    items.add(Pair.of((Object)((EnumItemSlot)slot.getFirst()), (Object)itemStack));
                }
            }
            case 3: {
                List packedItems;
                PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = (PacketPlayOutEntityMetadata)object;
                try {
                    int second23332;
                    int id = second23332 = packetPlayOutEntityMetadata.b();
                    List second23332 = packetPlayOutEntityMetadata.e();
                    packedItems = second23332;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (PacketItemModifier.isListening()) {
                    for (DataWatcher.c packedItem : packedItems) {
                        Object object2 = packedItem.c();
                        if (!(object2 instanceof ItemStack)) continue;
                        ItemStack stack = (ItemStack)object2;
                        WrappedItemStack wrapped = new WrappedItemStack(stack);
                        PacketItemModifier.callModify(wrapped, this.player, PacketItemModifier.Context.DROPPED_ITEM);
                    }
                }
                super.write(ctx, msg, promise);
                return;
            }
            case 4: {
                ClientboundBundlePacket packet = (ClientboundBundlePacket)object;
                if (PacketItemModifier.isListening()) {
                    for (Packet subPacket : packet.b()) {
                        List packedItems;
                        if (!(subPacket instanceof PacketPlayOutEntityMetadata)) continue;
                        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = (PacketPlayOutEntityMetadata)subPacket;
                        {
                            int n2;
                            int id = n2 = packetPlayOutEntityMetadata.b();
                            List list = packetPlayOutEntityMetadata.e();
                            packedItems = list;
                        }
                        for (DataWatcher.c packedItem : packedItems) {
                            Object object3 = packedItem.c();
                            if (!(object3 instanceof ItemStack)) continue;
                            ItemStack stack = (ItemStack)object3;
                            WrappedItemStack wrapped = new WrappedItemStack(stack);
                            PacketItemModifier.callModify(wrapped, this.player, PacketItemModifier.Context.DROPPED_ITEM);
                        }
                    }
                }
                super.write(ctx, msg, promise);
                return;
            }
            case 5: {
                PacketPlayOutOpenWindowMerchant packet = (PacketPlayOutOpenWindowMerchant)object;
                if (PacketItemModifier.isListening()) {
                    MerchantRecipeList offers = new MerchantRecipeList();
                    for (MerchantRecipe offer : packet.e()) {
                        MerchantRecipe newOffer = offer.v();
                        PacketItemModifier.callModify(new WrappedItemStack(newOffer.c.d()), this.player, PacketItemModifier.Context.MERCHANT_OFFER);
                        newOffer.d.ifPresent(cost -> PacketItemModifier.callModify(new WrappedItemStack(cost.d()), this.player, PacketItemModifier.Context.MERCHANT_OFFER));
                        PacketItemModifier.callModify(new WrappedItemStack(newOffer.e), this.player, PacketItemModifier.Context.MERCHANT_OFFER);
                        offers.add((Object)newOffer);
                    }
                    merchantAccessor.set(packet, offers);
                }
                super.write(ctx, msg, promise);
                return;
            }
        }
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (((Boolean)AxPlugin.flags().DEBUG.get()).booleanValue()) {
            log.error("An unhandled exception occurred on ctx {}!", (Object)ctx, (Object)cause);
        }
        super.exceptionCaught(ctx, cause);
    }
}

