/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.entity;

import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.collections.RawReferenceOpenHashSet;
import com.artillexstudios.axgraves.libs.axapi.collections.ThreadSafeList;
import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axgraves.libs.axapi.hologram.Holograms;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.entity.Serializers;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.packet.ClientboundSetPassengersWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.packet.ClientboundTeleportEntityWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.EntityMetaFactory;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axgraves.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axgraves.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axgraves.libs.axapi.utils.placeholder.StaticPlaceholder;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axgraves.libs.kyori.text.serializer.gson.GsonComponentSerializer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PacketEntity
implements com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity {
    private final int id;
    private final EntityMeta meta;
    private final EntityTypes<?> type;
    private final VecDeltaCodec codec = new VecDeltaCodec();
    private final Set<Player> invertedVisibilityEntities = Collections.newSetFromMap(new WeakHashMap());
    private final NonNullList<ItemStack> handSlots;
    private final NonNullList<ItemStack> armorSlots;
    private Location location;
    private EntityTracker.TrackedEntity tracker;
    private List<DataWatcher.c<?>> trackedValues;
    private Vec3D vec3;
    private volatile boolean shouldTeleport = false;
    private volatile boolean itemDirty = false;
    private boolean visibleByDefault = true;
    private int riddenEntityId = -1;
    private Consumer<PacketEntityInteractEvent> interactConsumer;
    private boolean hasInvertedVisibility = false;
    private float yHeadRot = 0.0f;
    private int viewDistanceSquared = 1024;

    public PacketEntity(EntityType entityType, Location location) {
        this.id = NMSHandlers.getNmsHandler().nextEntityId();
        this.type = EntityTypes.a((String)entityType.getName()).orElse(EntityTypes.d);
        this.meta = EntityMetaFactory.getForType(entityType);
        this.location = location;
        this.handSlots = NonNullList.a((int)2, (Object)ItemStack.l);
        this.armorSlots = NonNullList.a((int)4, (Object)ItemStack.l);
    }

    private static List<DataWatcher.c<?>> transform(List<Metadata.DataItem<?>> toTransform) {
        ArrayList<DataWatcher.c> dataValues = null;
        if (toTransform != null) {
            dataValues = new ArrayList<DataWatcher.c>(toTransform.size());
            for (Metadata.DataItem<?> dataItem : toTransform) {
                Serializers.Transformer transformer = Serializers.transformer(dataItem.getAccessor());
                dataValues.add(new DataWatcher.c(dataItem.getAccessor().id(), transformer.serializer(), transformer.transform(dataItem.getValue())));
            }
        }
        return dataValues;
    }

    private static PacketPlayOutSpawnEntity getAddEntityPacket(PacketEntity entity) {
        return new PacketPlayOutSpawnEntity(entity.id(), UUID.randomUUID(), entity.location().getX(), entity.location().getY(), entity.location().getZ(), entity.location().getPitch(), entity.location().getYaw(), entity.type, 1, Vec3D.b, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teleport(Location location) {
        this.location = location;
        VecDeltaCodec vecDeltaCodec = this.codec;
        synchronized (vecDeltaCodec) {
            this.vec3 = new Vec3D(location.getX(), location.getY(), location.getZ());
            this.shouldTeleport = true;
        }
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public EntityMeta meta() {
        return this.meta;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int viewDistanceSquared() {
        return this.viewDistanceSquared;
    }

    @Override
    public void viewDistance(int blocks) {
        this.viewDistanceSquared = blocks * blocks;
    }

    @Override
    public void spawn() {
        this.meta.metadata().markNotDirty();
        this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
        AxPlugin.tracker.addEntity(this);
    }

    @Override
    public void hide(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        } else {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        }
    }

    @Override
    public void show(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        } else {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        }
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.visibleByDefault = visible;
    }

    @Override
    public void setItem(EquipmentSlot slot, com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack item) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            this.handSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.l : ((WrappedItemStack)item).itemStack));
        } else {
            this.armorSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.l : ((WrappedItemStack)item).itemStack));
        }
        this.itemDirty = true;
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack getItem(EquipmentSlot slot) {
        return new WrappedItemStack(slot.getType() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.armorSlots.get(slot.getIndex()) : (ItemStack)this.handSlots.get(slot.getIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendChanges() {
        List<DataWatcher.c<?>> dirty;
        if (this.meta.metadata().isDirty() && (dirty = PacketEntity.transform(this.meta.metadata().packDirty())) != null) {
            this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
            HologramLine line = Holograms.byId(this.id);
            if (line == null || !line.hasPlaceholders()) {
                this.tracker.broadcast(new PacketPlayOutEntityMetadata(this.id, dirty));
            } else {
                Object[] objectArray = RawReferenceOpenHashSet.rawSet(this.tracker.seenBy);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object player = objectArray[i];
                    if (player == null) continue;
                    ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                    NMSHandlers.getNmsHandler().sendPacket(wrapper, (Object)new PacketPlayOutEntityMetadata(this.id, this.translate((Player)wrapper.wrapped(), line, dirty)));
                }
            }
        }
        if (this.itemDirty) {
            this.itemDirty = false;
            ArrayList equipments = Lists.newArrayList();
            for (EnumItemSlot slot : EnumItemSlot.values()) {
                ItemStack item = this.getItemBySlot(slot);
                if (item != null && !item.e()) {
                    ItemStack sanitised = item.s();
                    equipments.add(Pair.of((Object)slot, (Object)sanitised));
                    continue;
                }
                equipments.add(Pair.of((Object)slot, (Object)ItemStack.l));
            }
            if (!equipments.isEmpty()) {
                this.tracker.broadcast(new PacketPlayOutEntityEquipment(this.id, (List)equipments));
            }
        }
        if (this.shouldTeleport) {
            VecDeltaCodec vecDeltaCodec = this.codec;
            synchronized (vecDeltaCodec) {
                this.shouldTeleport = false;
                long k = this.codec.a(this.vec3);
                long l = this.codec.b(this.vec3);
                long i1 = this.codec.c(this.vec3);
                boolean flag6 = k < -32768L || k > 32767L || l < -32768L || l > 32767L || i1 < -32768L || i1 > 32767L;
                this.codec.e(this.vec3);
                if (!flag6) {
                    this.tracker.broadcast(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.id, (short)k, (short)l, (short)i1, (byte)(this.location.getYaw() * 256.0f / 360.0f), (byte)(this.location.getPitch() * 256.0f / 360.0f), true));
                } else {
                    this.tracker.broadcast(ClientboundTeleportEntityWrapper.createNew(this, this.location));
                }
            }
        }
    }

    @Override
    public void removePairing(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.id}));
    }

    @Override
    public void addPairing(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(PacketEntity.getAddEntityPacket(this));
        if (this.trackedValues != null) {
            HologramLine line = Holograms.byId(this.id);
            if (line == null || line.type() != HologramLine.Type.TEXT || !line.hasPlaceholders()) {
                list.add(new PacketPlayOutEntityMetadata(this.id, this.trackedValues));
            } else {
                list.add(new PacketPlayOutEntityMetadata(this.id, this.translate(player, line, this.trackedValues)));
            }
        }
        ArrayList equipments = Lists.newArrayList();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack item = this.getItemBySlot(slot);
            if (item == null || item.e()) continue;
            ItemStack sanitised = item.s();
            equipments.add(Pair.of((Object)slot, (Object)sanitised));
        }
        if (!equipments.isEmpty()) {
            list.add(new PacketPlayOutEntityEquipment(this.id, (List)equipments));
        }
        if (this.riddenEntityId != -1) {
            list.add(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[]{this.id}));
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.id);
        buf.k((int)((byte)MathHelper.d((float)(this.yHeadRot * 256.0f / 360.0f))));
        list.add((Packet)PacketPlayOutEntityHeadRotation.a.decode((Object)buf));
        buf.release();
        serverPlayer.c.b((Packet)new ClientboundBundlePacket(list));
    }

    @Override
    public boolean canSee(Player player) {
        if (!this.hasInvertedVisibility) {
            return this.visibleByDefault;
        }
        return this.visibleByDefault ^ this.invertedVisibilityEntities.contains(player);
    }

    @Override
    public void remove() {
        AxPlugin.tracker.removeEntity(this);
    }

    @Override
    public void onInteract(Consumer<PacketEntityInteractEvent> event) {
        this.interactConsumer = event;
    }

    @Override
    public void callInteract(PacketEntityInteractEvent event) {
        if (this.interactConsumer != null) {
            this.interactConsumer.accept(event);
        }
    }

    @Override
    public void ride(int entityId) {
        this.unRide(this.riddenEntityId);
        this.riddenEntityId = entityId;
        this.tracker.broadcast(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[]{this.id}));
    }

    @Override
    public void unRide(int entityId) {
        if (this.riddenEntityId == -1) {
            return;
        }
        this.tracker.broadcast(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[0]));
        this.riddenEntityId = -1;
    }

    @Override
    public void rotate(float yaw, float pitch) {
        this.location.setYaw(yaw);
        this.location.setPitch(pitch);
        this.tracker.broadcast(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.id, (byte)MathHelper.d((float)(yaw * 256.0f / 360.0f)), (byte)MathHelper.d((float)(pitch * 256.0f / 360.0f)), true));
    }

    @Override
    public void rotateHead(float yaw) {
        this.yHeadRot = yaw;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.id);
        buf.k((int)((byte)MathHelper.d((float)(yaw * 256.0f / 360.0f))));
        PacketPlayOutEntityHeadRotation packet = (PacketPlayOutEntityHeadRotation)PacketPlayOutEntityHeadRotation.a.decode((Object)buf);
        this.tracker.broadcast(packet);
        buf.release();
    }

    @Override
    public void update() {
        List<DataWatcher.c<?>> transformed = PacketEntity.transform(this.meta.metadata().packForNameUpdate());
        HologramLine line = Holograms.byId(this.id);
        if (line == null) {
            return;
        }
        for (Object player : RawReferenceOpenHashSet.rawSet(this.tracker.seenBy)) {
            if (player == null) continue;
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            NMSHandlers.getNmsHandler().sendPacket(wrapper, (Object)new PacketPlayOutEntityMetadata(this.id, this.translate((Player)wrapper.wrapped(), line, transformed)));
        }
    }

    private List<DataWatcher.c<?>> translate(Player player, HologramLine line, List<DataWatcher.c<?>> values) {
        ArrayList dataValues = new ArrayList(values);
        ListIterator<DataWatcher.c> iterator = dataValues.listIterator();
        while (iterator.hasNext()) {
            DataWatcher.c value = (DataWatcher.c)iterator.next();
            if (value.a() != 2 || line.type() != HologramLine.Type.TEXT) continue;
            Optional content = (Optional)value.c();
            if (content.isEmpty()) {
                return values;
            }
            String legacy = (String)legacyCache.get(content.get(), minecraftComponent -> {
                String gsonText = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)((IChatBaseComponent)minecraftComponent), (HolderLookup.a)MinecraftServer.getServer().bc());
                Object gsonComponent = GsonComponentSerializer.gson().deserialize(gsonText);
                return LEGACY_COMPONENT_SERIALIZER.serialize((Component)gsonComponent);
            });
            if (legacy == null) {
                return values;
            }
            ThreadSafeList<Placeholder> placeholders = line.placeholders();
            for (int i = 0; i < placeholders.size(); ++i) {
                Placeholder placeholder = placeholders.get(i);
                if (placeholder instanceof StaticPlaceholder) continue;
                legacy = placeholder.parse(player, legacy);
            }
            IChatBaseComponent component = (IChatBaseComponent)componentCache.get((Object)legacy, legacyText -> {
                Component formatted = StringUtils.format(legacyText, new TagResolver[0]);
                String gson = (String)GsonComponentSerializer.gson().serialize(formatted);
                return IChatBaseComponent.ChatSerializer.a((String)gson, (HolderLookup.a)MinecraftServer.getServer().bc());
            });
            iterator.remove();
            iterator.add(new DataWatcher.c(value.a(), value.b(), Optional.ofNullable(component)));
            break;
        }
        return dataValues;
    }

    private ItemStack getItemBySlot(EnumItemSlot slot) {
        return switch (slot.a()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.b -> (ItemStack)this.armorSlots.get(slot.b());
            case EnumItemSlot.Function.a -> (ItemStack)this.handSlots.get(slot.b());
            case EnumItemSlot.Function.c -> null;
        };
    }
}

