/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3;

import com.artillexstudios.axgraves.libs.axapi.gui.AnvilInput;
import com.artillexstudios.axgraves.libs.axapi.gui.SignInput;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.BlockSetterImpl;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.ItemStackSerializer;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.ParallelBlockSetterImpl;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.entity.PacketEntity;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.items.data.DataComponentImpl;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.items.nbt.CompoundTag;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.loot.LootTable;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.packet.PacketListener;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.utils.ActionBar;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.utils.BossBar;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.utils.DebugMarker;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.utils.Title;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.reflection.FastFieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.selection.BlockSetter;
import com.artillexstudios.axgraves.libs.axapi.selection.ParallelBlockSetter;
import com.artillexstudios.axgraves.libs.axapi.serializers.Serializer;
import com.artillexstudios.axgraves.libs.axapi.utils.BossBar;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.axapi.utils.Pair;
import com.artillexstudios.axgraves.libs.kyori.key.Key;
import com.artillexstudios.axgraves.libs.kyori.text.Component;
import com.artillexstudios.axgraves.libs.kyori.text.serializer.gson.GsonComponentSerializer;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class NMSHandler
implements com.artillexstudios.axgraves.libs.axapi.nms.NMSHandler {
    private static final FastFieldAccessor ELEMENT_DATA = FastFieldAccessor.forClassField(ArrayList.class, "elementData");
    private final String AXAPI_HANDLER;
    private Field channelField;
    private Field connectionField;
    private AtomicInteger entityCounter;
    private FastFieldAccessor attributeSupplierAccessor;

    public NMSHandler(JavaPlugin plugin) {
        this.AXAPI_HANDLER = "axapi_handler_" + plugin.getName().toLowerCase(Locale.ENGLISH);
        try {
            this.connectionField = Class.forName("net.minecraft.server.network.ServerCommonPacketListenerImpl").getDeclaredField("c");
            this.connectionField.setAccessible(true);
            this.channelField = Class.forName("net.minecraft.network.NetworkManager").getDeclaredField("n");
            this.channelField.setAccessible(true);
            Field entityIdField = Entity.class.getDeclaredField("d");
            entityIdField.setAccessible(true);
            this.entityCounter = (AtomicInteger)entityIdField.get(null);
            this.attributeSupplierAccessor = FastFieldAccessor.forClassField(AttributeMapBase.class, "d");
        }
        catch (Exception exception) {
            log.error("An exception occurred while initializing NMSHandler!", (Throwable)exception);
        }
    }

    @Override
    public Serializer<Object, Component> componentSerializer() {
        return new Serializer<Object, Component>(){

            @Override
            public Component serialize(Object object) {
                if (!(object instanceof IChatBaseComponent)) {
                    throw new IllegalStateException("Can only serialize component!");
                }
                IChatBaseComponent component = (IChatBaseComponent)object;
                String gsonText = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)component);
                return GsonComponentSerializer.gson().deserialize(gsonText);
            }

            @Override
            public Object deserialize(Component value) {
                return IChatBaseComponent.ChatSerializer.a((JsonElement)GsonComponentSerializer.gson().serializer().toJsonTree(value));
            }
        };
    }

    @Override
    public void injectPlayer(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = this.getChannel(this.getConnection((ServerCommonPacketListenerImpl)serverPlayer.c));
        if (!channel.pipeline().names().contains("packet_handler")) {
            return;
        }
        if (channel.pipeline().names().contains(this.AXAPI_HANDLER)) {
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", this.AXAPI_HANDLER, (ChannelHandler)new PacketListener(player)));
    }

    @Override
    public void uninjectPlayer(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = this.getChannel(this.getConnection((ServerCommonPacketListenerImpl)serverPlayer.c));
        channel.eventLoop().submit(() -> {
            if (channel.pipeline().get(this.AXAPI_HANDLER) != null) {
                channel.pipeline().remove(this.AXAPI_HANDLER);
            }
        });
    }

    @Override
    public int getProtocolVersionId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.c.c.protocolVersion;
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity createEntity(EntityType entityType, Location location) {
        return new PacketEntity(entityType, location);
    }

    @Override
    public BlockSetter newSetter(World world) {
        return new BlockSetterImpl(world);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.utils.ActionBar newActionBar(Component content) {
        return new ActionBar(content);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.utils.Title newTitle(Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        return new Title(title, subtitle, fadeIn, stay, fadeOut);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.utils.BossBar newBossBar(Component title, float progress, BossBar.Color color, BossBar.Style style, BossBar.Flag ... flags) {
        return new BossBar(title, progress, color, style, flags);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.nbt.CompoundTag newTag() {
        return new CompoundTag(new NBTTagCompound());
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack wrapItem(ItemStack itemStack) {
        return new WrappedItemStack(itemStack);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack wrapItem(String snbt) {
        try {
            NBTTagCompound tag = MojangsonParser.a((String)snbt);
            int dataVersion = tag.h("DataVersion");
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().M.update(DataConverterTypes.t, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)tag), dataVersion, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            net.minecraft.world.item.ItemStack item = net.minecraft.world.item.ItemStack.a((NBTTagCompound)converted);
            return new WrappedItemStack(item);
        }
        catch (CommandSyntaxException exception) {
            log.error("An error occurred while parsing item from SNBT!", (Throwable)exception);
            return null;
        }
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack wrapItem(byte[] bytes) {
        return this.wrapItem(ItemStackSerializer.INSTANCE.deserializeFromBytes(bytes));
    }

    @Override
    public void openSignInput(SignInput signInput) {
        EntityPlayer player = ((CraftPlayer)signInput.getPlayer()).getHandle();
        BlockPosition pos = CraftLocation.toBlockPosition((Location)signInput.getLocation());
        player.c.b((Packet)new PacketPlayOutBlockChange(pos, ((CraftBlockData)Material.OAK_SIGN.createBlockData()).getState()));
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(pos);
        buf.a((Registry)BuiltInRegistries.k, (Object)TileEntityTypes.h);
        NBTTagCompound tag = new NBTTagCompound();
        tag.a("x", pos.u());
        tag.a("y", pos.v());
        tag.a("z", pos.w());
        tag.a("id", "minecraft:oak_sign");
        if (!tag.e("front_text")) {
            tag.a("front_text", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound sideTag = tag.p("front_text");
        if (!tag.e("messages")) {
            sideTag.a("messages", (NBTBase)new NBTTagList());
        }
        NBTTagList messagesNbt = sideTag.c("messages", 8);
        for (int i = 0; i < 4; ++i) {
            String gson = this.toGson(i > signInput.getLines().length ? Component.empty() : signInput.getLines()[i]);
            messagesNbt.c(i, (NBTBase)NBTTagString.a((String)gson));
        }
        buf.a((NBTBase)tag);
        PacketPlayOutTileEntityData clientboundBlockEntityDataPacket = new PacketPlayOutTileEntityData(buf);
        PacketPlayOutOpenSignEditor openSignEditorPacket = new PacketPlayOutOpenSignEditor(pos, true);
        player.c.b((Packet)clientboundBlockEntityDataPacket);
        player.c.b((Packet)openSignEditorPacket);
        buf.release();
    }

    @Override
    public void setTitle(Inventory inventory, Component title) {
        IChatBaseComponent nmsTitle = (IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(title);
        for (HumanEntity viewer : inventory.getViewers()) {
            CraftPlayer craftPlayer = (CraftPlayer)viewer;
            EntityPlayer serverPlayer = craftPlayer.getHandle();
            int containerId = serverPlayer.bS.j;
            Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
            serverPlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerId, windowType, nmsTitle));
            craftPlayer.updateInventory();
        }
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.component.DataComponentImpl dataComponents() {
        return new DataComponentImpl();
    }

    @Override
    public OfflinePlayer getCachedOfflinePlayer(String name) {
        GameProfile profile;
        Player result = Bukkit.getPlayerExact((String)name);
        if (result == null && (profile = MinecraftServer.getServer().ar().getProfileIfCached(name)) != null) {
            result = ((CraftServer)Bukkit.getServer()).getOfflinePlayer(profile);
        }
        return result;
    }

    @Override
    public void sendPacket(Player player, Object packet) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.c.b((Packet)packet);
    }

    @Override
    public void sendPacket(com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper player, Object packet) {
        EntityPlayer serverPlayer = (EntityPlayer)player.asMinecraft();
        serverPlayer.c.b((Packet)packet);
    }

    @Override
    public ParallelBlockSetter newParallelSetter(World world) {
        return new ParallelBlockSetterImpl(world);
    }

    @Override
    public int nextEntityId() {
        return this.entityCounter.incrementAndGet();
    }

    @Override
    public Pair<String, String> textures(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        GameProfile profile = serverPlayer.fR();
        Optional property = profile.getProperties().get((Object)"textures").stream().findFirst();
        return property.map(value -> Pair.of(value.value(), value.signature())).orElse(null);
    }

    @Override
    public void sendMessage(Player player, Component message) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.c.b((Packet)new ClientboundSystemChatPacket((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(message), false));
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.utils.DebugMarker marker(Color color, String message, int duration, int transparency, Location location) {
        return new DebugMarker(color, message, duration, transparency, location);
    }

    @Override
    public double getBase(Player player, Attribute attribute) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        AttributeMapBase map = serverPlayer.eR();
        AttributeProvider supplier = (AttributeProvider)this.attributeSupplierAccessor.get(map);
        return supplier.b(CraftAttribute.bukkitToMinecraft((Attribute)attribute));
    }

    @Override
    public Player dummyPlayer() {
        return new EntityPlayer(MinecraftServer.getServer(), ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle(), new GameProfile(UUID.randomUUID(), "dummy"), ClientInformation.a()).getBukkitEntity();
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.loot.LootTable lootTable(Key key) {
        return new LootTable(key);
    }

    @Override
    public List<com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper> players(World world) {
        ObjectArrayList playerList;
        block3: {
            List players;
            block2: {
                CraftWorld craftWorld = (CraftWorld)world;
                WorldServer level = craftWorld.getHandle();
                players = level.x();
                int size = players.size();
                playerList = new ObjectArrayList(size);
                if (!(players instanceof ArrayList)) break block2;
                ArrayList arrayList = (ArrayList)players;
                Object[] serverPlayers = (Object[])ELEMENT_DATA.get(arrayList);
                for (int i = 0; i < size; ++i) {
                    EntityPlayer serverPlayer = (EntityPlayer)serverPlayers[i];
                    if (serverPlayer == null) continue;
                    playerList.add(new ServerPlayerWrapper(serverPlayer));
                }
                break block3;
            }
            if (!(players instanceof LinkedList)) break block3;
            LinkedList linkedList = (LinkedList)players;
            for (EntityPlayer serverPlayer : linkedList.toArray(new EntityPlayer[0])) {
                playerList.add(new ServerPlayerWrapper(serverPlayer));
            }
        }
        return playerList;
    }

    @Override
    public void openAnvilInput(AnvilInput anvilInput) {
        Player player = anvilInput.player();
        player.closeInventory();
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        Location location = anvilInput.location();
        ContainerAnvil anvilMenu = new ContainerAnvil(serverPlayer.nextContainerCounter(), serverPlayer.fS(), ContainerAccess.a((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), (BlockPosition)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        anvilMenu.checkReachable = false;
        anvilMenu.setTitle((IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla(anvilInput.title()));
        Inventory inventory = anvilMenu.getBukkitView().getTopInventory();
        inventory.setItem(0, anvilInput.itemStack().toBukkit());
        this.sendPacket(player, (Object)new PacketPlayOutOpenWindow(anvilMenu.j, anvilMenu.a(), anvilMenu.getTitle()));
        serverPlayer.bS = anvilMenu;
        serverPlayer.a((Container)anvilMenu);
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper wrapper(Object player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer sp = (EntityPlayer)player;
            return new ServerPlayerWrapper(sp);
        }
        if (player instanceof Player) {
            Player pl = (Player)player;
            return new ServerPlayerWrapper(pl);
        }
        return null;
    }

    public String toGson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    private Channel getChannel(NetworkManager connection) {
        try {
            return (Channel)this.channelField.get(connection);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private NetworkManager getConnection(ServerCommonPacketListenerImpl serverGamePacketListener) {
        try {
            return (NetworkManager)this.connectionField.get(serverGamePacketListener);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

