/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.yamlassist;

import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.SyntaxError;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.BadIndentation;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.DoubleMapping;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.InvalidLine;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.InvalidList;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.MissingQuote;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.MissingSpaceBeforeValue;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.QuoteWrapRequired;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.TABIndent;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.UnknownEscape;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlAssist {
    private static Map<Class<? extends SyntaxError>, SyntaxError> registeredSyntaxErrors = new HashMap<Class<? extends SyntaxError>, SyntaxError>();

    public static List<String> getSuggestions(File file) {
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            if (file == null) {
                throw new IllegalArgumentException("File cannot be null");
            }
            if (!file.exists()) {
                throw new IllegalStateException("File does not exist");
            }
            FileInputStream input = new FileInputStream(file);
            try {
                new Yaml().load((InputStream)input);
            }
            catch (YAMLException exception) {
                for (SyntaxError possibleError : registeredSyntaxErrors.values()) {
                    suggestions.addAll(possibleError.getSuggestions(exception, Files.readAllLines(file.toPath())));
                }
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return suggestions;
    }

    public static void registerSyntaxError(SyntaxError error) {
        registeredSyntaxErrors.put(error.getClass(), error);
    }

    public static <T> T getError(Class<T> clazz) {
        return (T)registeredSyntaxErrors.get(clazz);
    }

    static {
        YamlAssist.registerSyntaxError(new DoubleMapping());
        YamlAssist.registerSyntaxError(new InvalidList());
        YamlAssist.registerSyntaxError(new InvalidLine());
        YamlAssist.registerSyntaxError(new MissingQuote());
        YamlAssist.registerSyntaxError(new MissingSpaceBeforeValue());
        YamlAssist.registerSyntaxError(new QuoteWrapRequired());
        YamlAssist.registerSyntaxError(new TABIndent());
        YamlAssist.registerSyntaxError(new UnknownEscape());
        YamlAssist.registerSyntaxError(new BadIndentation());
    }
}

