/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.libby.logging.adapters;

import com.artillexstudios.axgraves.libs.axapi.libs.libby.logging.LogLevel;
import com.artillexstudios.axgraves.libs.axapi.libs.libby.logging.adapters.LogAdapter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDKLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JDKLogAdapter(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable String message) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, message);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, message);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, message);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, message);
            }
        }
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable String message, @Nullable Throwable throwable) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, message, throwable);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, message, throwable);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, message, throwable);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, message, throwable);
            }
        }
    }
}

