/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi;

import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.gui.AnvilListener;
import com.artillexstudios.axgraves.libs.axapi.hologram.Holograms;
import com.artillexstudios.axgraves.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axgraves.libs.axapi.libs.libby.BukkitLibraryManager;
import com.artillexstudios.axgraves.libs.axapi.libs.libby.Library;
import com.artillexstudios.axgraves.libs.axapi.libs.libby.logging.LogLevel;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderAPIHook;
import com.artillexstudios.axgraves.libs.axapi.placeholders.Placeholders;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class AxPlugin
extends JavaPlugin {
    public static EntityTracker tracker;
    private static FeatureFlags flags;

    public AxPlugin() {
        flags = new FeatureFlags(this);
        this.updateFlags(flags);
    }

    public void updateFlags(FeatureFlags flags) {
    }

    public void onEnable() {
        if (!NMSHandlers.British.initialise(this)) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DataComponents.setDataComponentImpl(NMSHandlers.getNmsHandler().dataComponents());
        Scheduler.scheduler.init(this);
        if (((Boolean)AxPlugin.flags.PACKET_ENTITY_TRACKER_ENABLED.get()).booleanValue()) {
            tracker = new EntityTracker();
            tracker.startTicking();
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerQuitEvent(@NotNull PlayerQuitEvent event) {
                NMSHandlers.getNmsHandler().uninjectPlayer(event.getPlayer());
                if (tracker == null) {
                    return;
                }
                tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }

            @EventHandler
            public void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
                NMSHandlers.getNmsHandler().injectPlayer(event.getPlayer());
            }

            @EventHandler
            public void onPacketEntityInteractEvent(@NotNull PacketEntityInteractEvent event) {
                event.getPacketEntity().callInteract(event);
            }

            @EventHandler
            public void onPlayerChangedWorldEvent(@NotNull PlayerChangedWorldEvent event) {
                if (tracker == null) {
                    return;
                }
                tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }
        }, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AnvilListener(), (Plugin)this);
        if ((Long)AxPlugin.flags.HOLOGRAM_UPDATE_TICKS.get() > 0L) {
            Holograms.startTicking();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            NMSHandlers.getNmsHandler().injectPlayer(player);
        }
        this.enable();
        Placeholders.lock();
        if (((Boolean)AxPlugin.flags.PLACEHOLDER_API_HOOK.get()).booleanValue() && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook().register();
        }
    }

    public void enable() {
    }

    public void onLoad() {
        BukkitLibraryManager libraryManager = new BukkitLibraryManager((Plugin)this);
        libraryManager.addMavenCentral();
        Library commonsMath = Library.builder().groupId("org{}apache{}commons").artifactId("commons-math3").version("3.6.1").relocate("org{}apache{}commons{}math3", "com.artillexstudios.axgraves.libs.axapi.libs.math3").build();
        Library caffeine = Library.builder().groupId("com{}github{}ben-manes{}caffeine").artifactId("caffeine").version("3.1.8").relocate("com{}github{}benmanes", "com.artillexstudios.axgraves.libs.axapi.libs.caffeine").build();
        if (((Boolean)AxPlugin.flags.DEBUG.get()).booleanValue()) {
            libraryManager.setLogLevel(LogLevel.DEBUG);
        }
        libraryManager.loadLibrary(commonsMath);
        libraryManager.loadLibrary(caffeine);
        this.load();
    }

    public void load() {
    }

    public void onDisable() {
        this.disable();
        Scheduler.get().cancelAll();
        for (Player player : Bukkit.getOnlinePlayers()) {
            NMSHandlers.getNmsHandler().uninjectPlayer(player);
        }
        if (tracker != null) {
            tracker.shutdown();
        }
        Holograms.shutdown();
    }

    public void disable() {
    }

    public void reload() {
    }

    public long reloadWithTime() {
        long start = System.currentTimeMillis();
        this.reload();
        return System.currentTimeMillis() - start;
    }

    public static FeatureFlags flags() {
        return flags;
    }
}

