/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves;

import com.artillexstudios.axgraves.commands.Commands;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.config.Config;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axgraves.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axgraves.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axgraves.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axgraves.listeners.DeathListener;
import com.artillexstudios.axgraves.listeners.PlayerInteractListener;
import com.artillexstudios.axgraves.schedulers.SaveGraves;
import com.artillexstudios.axgraves.schedulers.TickGraves;
import com.artillexstudios.axgraves.utils.UpdateNotifier;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class AxGraves
extends AxPlugin {
    private static AxPlugin instance;
    public static Config CONFIG;
    public static Config MESSAGES;
    public static MessageUtils MESSAGEUTILS;
    public static ScheduledExecutorService EXECUTOR;

    public static AxPlugin getInstance() {
        return instance;
    }

    @Override
    public void enable() {
        instance = this;
        int pluginId = 20332;
        new Metrics(this, pluginId);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGES = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(MESSAGES.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        this.getServer().getPluginManager().registerEvents((Listener)new DeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        BukkitCommandHandler handler = BukkitCommandHandler.create((Plugin)instance);
        handler.register(new Commands());
        if (CONFIG.getBoolean("save-graves.enabled", true)) {
            SpawnedGraves.loadFromFile();
        }
        TickGraves.start();
        SaveGraves.start();
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5076);
        }
    }

    @Override
    public void disable() {
        TickGraves.stop();
        SaveGraves.stop();
        for (Grave grave : SpawnedGraves.getGraves()) {
            if (!CONFIG.getBoolean("save-graves.enabled", true)) {
                grave.remove();
            }
            if (grave.getEntity() != null) {
                grave.getEntity().remove();
            }
            if (grave.getHologram() == null) continue;
            grave.getHologram().remove();
        }
        if (CONFIG.getBoolean("save-graves.enabled", true)) {
            SpawnedGraves.saveToFile();
        }
        EXECUTOR.shutdown();
    }

    @Override
    public void updateFlags(FeatureFlags flags) {
        flags.USE_LEGACY_HEX_FORMATTER.set(true);
        flags.PACKET_ENTITY_TRACKER_ENABLED.set(true);
        flags.HOLOGRAM_UPDATE_TICKS.set(5L);
    }

    static {
        EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    }
}

