/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.view;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareReader;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareWriter;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.view.InventoryStatus;
import org.mvplugins.multiverse.inventories.view.PlayerInventoryData;

@Service
@ApiStatus.Experimental
@ApiStatus.AvailableSince(value="5.2")
public final class InventoryDataProvider {
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final MultiverseInventories inventories;
    private final InventoriesConfig inventoriesConfig;

    @Inject
    InventoryDataProvider(@NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull MultiverseInventories inventories, @NotNull InventoriesConfig inventoriesConfig) {
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.inventories = inventories;
        this.inventoriesConfig = inventoriesConfig;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public CompletableFuture<PlayerInventoryData> loadPlayerInventoryData(@NotNull OfflinePlayer targetPlayer, @NotNull String worldName) {
        if (!targetPlayer.isOnline()) {
            return this.loadInventoryDataFromProfileStorage(targetPlayer, worldName);
        }
        Player onlineTarget = targetPlayer.getPlayer();
        if (onlineTarget != null && onlineTarget.getWorld().getName().equalsIgnoreCase(worldName)) {
            return this.loadInventoryDataFromPlayer(onlineTarget, worldName);
        }
        if (onlineTarget != null) {
            InvLogging.fine("Player " + targetPlayer.getName() + " is online but in world " + onlineTarget.getWorld().getName() + ". Loading stored data for " + worldName + ".", new Object[0]);
        } else {
            InvLogging.warning("Player " + targetPlayer.getName() + " is online but getPlayer() returned null. Falling back to stored data.", new Object[0]);
        }
        return this.loadInventoryDataFromProfileStorage(targetPlayer, worldName);
    }

    private CompletableFuture<PlayerInventoryData> loadInventoryDataFromPlayer(@NotNull Player onlineTarget, @NotNull String worldName) {
        ProfileType profileType = ProfileTypes.forPlayer(onlineTarget);
        return CompletableFuture.completedFuture(new PlayerInventoryData(onlineTarget.getInventory().getContents(), onlineTarget.getInventory().getArmorContents(), onlineTarget.getInventory().getItemInOffHand(), InventoryStatus.LIVE_INVENTORY, profileType, onlineTarget.getHealth(), onlineTarget.getMaxHealth(), onlineTarget.getLevel(), Float.valueOf(onlineTarget.getExp()), onlineTarget.getFoodLevel(), Float.valueOf(onlineTarget.getSaturation()), String.format("%s (%.1f, %.1f, %.1f)", onlineTarget.getWorld().getName(), onlineTarget.getLocation().getX(), onlineTarget.getLocation().getY(), onlineTarget.getLocation().getZ())));
    }

    private CompletableFuture<PlayerInventoryData> loadInventoryDataFromProfileStorage(@NotNull OfflinePlayer targetPlayer, @NotNull String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ProfileContainer container = this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(worldName);
            if (container == null) {
                throw new IllegalStateException("Could not load profile container for world: " + worldName);
            }
            PlayerProfile tempProfile = this.loadMVInvPlayerProfile(container, targetPlayer);
            if (tempProfile == null) {
                throw new IllegalStateException(InventoryStatus.NO_DATA_FOUND.getFormattedMessage(targetPlayer.getName(), worldName));
            }
            ProfileType profileTypeToUse = tempProfile.getProfileType();
            try {
                Location storedLocationObject;
                ItemStack[] contents = SingleShareReader.of(this.inventories, targetPlayer, worldName, profileTypeToUse, Sharables.INVENTORY).read().join();
                ItemStack[] armor = SingleShareReader.of(this.inventories, targetPlayer, worldName, profileTypeToUse, Sharables.ARMOR).read().join();
                ItemStack offHand = SingleShareReader.of(this.inventories, targetPlayer, worldName, profileTypeToUse, Sharables.OFF_HAND).read().join();
                Double storedHealth = this.getSharableValue(Sharables.HEALTH, targetPlayer, worldName, profileTypeToUse);
                Double storedMaxHealth = this.getSharableValue(Sharables.MAX_HEALTH, targetPlayer, worldName, profileTypeToUse);
                Integer storedLevel = this.getSharableValue(Sharables.LEVEL, targetPlayer, worldName, profileTypeToUse);
                Float storedExp = this.getSharableValue(Sharables.EXPERIENCE, targetPlayer, worldName, profileTypeToUse);
                Integer storedFoodLevel = this.getSharableValue(Sharables.FOOD_LEVEL, targetPlayer, worldName, profileTypeToUse);
                Float storedSaturationLevel = this.getSharableValue(Sharables.SATURATION, targetPlayer, worldName, profileTypeToUse);
                Object storedLastLocation = !this.inventoriesConfig.getActiveOptionalShares().contains(Sharables.LAST_LOCATION) ? String.valueOf(ChatColor.RED) + "Disabled in Config" : ((storedLocationObject = SingleShareReader.of(this.inventories, targetPlayer, worldName, profileTypeToUse, Sharables.LAST_LOCATION).read().join()) == null || storedLocationObject.getWorld() == null ? "N/A (No Location Data)" : String.format("%s (%.1f, %.1f, %.1f)", storedLocationObject.getWorld().getName(), storedLocationObject.getX(), storedLocationObject.getY(), storedLocationObject.getZ()));
                return new PlayerInventoryData(contents, armor, offHand, InventoryStatus.STORED_INVENTORY, profileTypeToUse, storedHealth, storedMaxHealth, storedLevel, storedExp, storedFoodLevel, storedSaturationLevel, (String)storedLastLocation);
            }
            catch (CompletionException e) {
                throw new IllegalStateException("Error loading inventory data: " + e.getCause().getMessage(), e.getCause());
            }
        });
    }

    @Nullable
    private PlayerProfile loadMVInvPlayerProfile(ProfileContainer container, OfflinePlayer targetPlayer) {
        PlayerProfile survivalProfile = container.getPlayerProfileNow(ProfileTypes.SURVIVAL, targetPlayer);
        if (survivalProfile != null) {
            return survivalProfile;
        }
        for (ProfileType type : ProfileTypes.getTypes()) {
            PlayerProfile profile;
            if (type.equals(ProfileTypes.SURVIVAL) || (profile = container.getPlayerProfileNow(type, targetPlayer)) == null) continue;
            return profile;
        }
        return null;
    }

    private <T> T getSharableValue(@NotNull Sharable<T> sharable, @NotNull OfflinePlayer targetPlayer, @NotNull String worldName, @NotNull ProfileType profileType) {
        try {
            T value = SingleShareReader.of(this.inventories, targetPlayer, worldName, profileType, sharable).read().join();
            return value;
        }
        catch (CompletionException e) {
            InvLogging.warning("Failed to read sharable '" + sharable.getNames()[0] + "' for player " + targetPlayer.getName() + " in world " + worldName + ": " + e.getCause().getMessage(), new Object[0]);
            return null;
        }
    }

    @ApiStatus.AvailableSince(value="5.2")
    public CompletableFuture<Void> savePlayerInventoryData(@NotNull OfflinePlayer targetPlayer, @NotNull String worldName, @NotNull ProfileType profileType, @NotNull ItemStack[] newContents, @NotNull ItemStack[] newArmor, @Nullable ItemStack newOffHand) {
        CompletableFuture<Void> saveFuture = this.writeInventoryDataToProfile(targetPlayer, worldName, profileType, newContents, newArmor, newOffHand);
        return ((CompletableFuture)saveFuture.thenRun(() -> {
            InvLogging.info("Inventory for player " + targetPlayer.getName() + " in world " + worldName + " has been modified and saved.", new Object[0]);
            this.updateOnlinePlayerInventoryData(targetPlayer, worldName, newContents, newArmor, newOffHand);
        })).exceptionally(throwable -> {
            InvLogging.severe("Failed to save inventory for " + targetPlayer.getName() + " in world " + worldName + ": " + throwable.getMessage(), new Object[0]);
            throwable.printStackTrace();
            return null;
        });
    }

    private void updateOnlinePlayerInventoryData(OfflinePlayer targetPlayer, String worldName, @NotNull ItemStack[] newContents, @NotNull ItemStack[] newArmor, ItemStack newOffHand) {
        if (!targetPlayer.isOnline()) {
            return;
        }
        Player onlinePlayer = targetPlayer.getPlayer();
        if (onlinePlayer == null) {
            return;
        }
        if (!onlinePlayer.getWorld().getName().equalsIgnoreCase(worldName)) {
            InvLogging.info("Player " + onlinePlayer.getName() + " is online but in a different world (" + onlinePlayer.getWorld().getName() + "), not updating live inventory.", new Object[0]);
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.inventories, () -> {
            onlinePlayer.getInventory().setContents(newContents);
            onlinePlayer.getInventory().setArmorContents(newArmor);
            onlinePlayer.getInventory().setItemInOffHand(newOffHand);
            onlinePlayer.updateInventory();
            InvLogging.info("Updated live inventory for online player " + onlinePlayer.getName() + " in world " + worldName, new Object[0]);
        });
    }

    private CompletableFuture<Void> writeInventoryDataToProfile(@NotNull OfflinePlayer targetPlayer, @NotNull String worldName, @NotNull ProfileType profileType, @NotNull ItemStack[] newContents, @NotNull ItemStack[] newArmor, @Nullable ItemStack newOffHand) {
        return CompletableFuture.allOf(new CompletableFuture[]{SingleShareWriter.of(this.inventories, targetPlayer, worldName, profileType, Sharables.INVENTORY).write(newContents, true).thenRun(() -> InvLogging.fine("Saved inventory for " + targetPlayer.getName() + " in " + worldName, new Object[0])), SingleShareWriter.of(this.inventories, targetPlayer, worldName, profileType, Sharables.ARMOR).write(newArmor, true).thenRun(() -> InvLogging.fine("Saved armor for " + targetPlayer.getName() + " in " + worldName, new Object[0])), SingleShareWriter.of(this.inventories, targetPlayer, worldName, profileType, Sharables.OFF_HAND).write(newOffHand, true).thenRun(() -> InvLogging.fine("Saved off-hand for " + targetPlayer.getName() + " in " + worldName, new Object[0]))});
    }
}

