/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.key;

import com.google.common.base.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

public final class ProfileKey
extends ProfileFileKey {
    private final ProfileType profileType;

    public static ProfileKey fromPlayerProfile(PlayerProfile profile) {
        return ProfileKey.of(profile.getContainerType(), profile.getContainerName(), profile.getProfileType(), profile.getPlayerUUID(), profile.getPlayerName());
    }

    public static ProfileKey of(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID) {
        return ProfileKey.of(containerType, dataName, profileType, GlobalProfileKey.of(playerUUID));
    }

    public static ProfileKey of(ContainerType containerType, String dataName, ProfileType profileType, GlobalProfileKey globalProfileKey) {
        return ProfileKey.of(containerType, dataName, profileType, globalProfileKey.getPlayerUUID(), globalProfileKey.getPlayerName());
    }

    public static ProfileKey of(ContainerType containerType, String dataName, ProfileType profileType, OfflinePlayer offlinePlayer) {
        return ProfileKey.of(containerType, dataName, profileType, offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    public static ProfileKey of(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID, String playerName) {
        return new ProfileKey(containerType, dataName, profileType, playerUUID, playerName);
    }

    private ProfileKey(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID, String playerName) {
        super(containerType, dataName, playerUUID, playerName, Objects.hashCode((Object[])new Object[]{containerType, dataName, profileType, playerUUID}));
        this.profileType = profileType;
    }

    @Override
    @ApiStatus.AvailableSince(value="5.3")
    public ProfileKey forContainer(@NotNull ContainerKey containerKey) {
        return new ProfileKey(containerKey.getContainerType(), containerKey.getDataName(), this.profileType, this.playerUUID, this.playerName);
    }

    @Override
    public ProfileKey forContainerType(@NotNull ContainerType containerType) {
        return new ProfileKey(containerType, this.dataName, this.profileType, this.playerUUID, this.playerName);
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileKey)) {
            return false;
        }
        ProfileKey that = (ProfileKey)o;
        return this.getContainerType() == that.getContainerType() && Objects.equal((Object)this.getDataName(), (Object)that.getDataName()) && Objects.equal((Object)this.getProfileType(), (Object)that.getProfileType()) && Objects.equal((Object)this.getPlayerUUID(), (Object)that.getPlayerUUID());
    }

    @Override
    public String toString() {
        return "ProfileKey{containerType=" + String.valueOf((Object)this.containerType) + ", dataName='" + this.dataName + "', profileType=" + String.valueOf(this.profileType) + ", playerName='" + this.playerName + "', playerUUID=" + String.valueOf(this.playerUUID) + "}";
    }
}

