/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.group;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventPriority;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.core.utils.matcher.MatcherGroup;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class WorldGroup {
    private final WorldGroupManager worldGroupManager;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final InventoriesConfig inventoriesConfig;
    private final String name;
    private final Set<String> configWorlds = new LinkedHashSet<String>();
    private final Shares shares = Sharables.noneOf();
    private final Shares disabledShares = Sharables.noneOf();
    private String spawnWorld = null;
    private EventPriority spawnPriority = EventPriority.NORMAL;
    private MatcherGroup matcherGroup = new MatcherGroup();
    private Set<String> applicableWorlds = new LinkedHashSet<String>();
    private Shares applicableShares = Sharables.noneOf();

    WorldGroup(WorldGroupManager worldGroupManager, ProfileContainerStoreProvider profileContainerStoreProvider, InventoriesConfig inventoriesConfig, String name) {
        this.worldGroupManager = worldGroupManager;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.inventoriesConfig = inventoriesConfig;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addWorld(String worldName) {
        this.addWorld(worldName, true);
    }

    public void addWorld(String worldName, boolean updateConfig) {
        this.configWorlds.add(worldName.toLowerCase());
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void addWorld(World world) {
        this.addWorld(world.getName());
    }

    public void addWorlds(Collection<String> worlds) {
        this.addWorlds(worlds, true);
    }

    public void addWorlds(Collection<String> worlds, boolean updateConfig) {
        this.configWorlds.addAll(worlds.stream().map(String::toLowerCase).toList());
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void removeWorld(String worldName) {
        this.removeWorld(worldName, true);
    }

    public void removeWorld(String worldName, boolean updateConfig) {
        this.configWorlds.remove(worldName.toLowerCase());
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void removeWorld(World world) {
        this.removeWorld(world.getName());
    }

    public boolean removeWorlds(Collection<String> removeWorlds) {
        return this.removeWorlds(removeWorlds, true);
    }

    public boolean removeWorlds(Collection<String> removeWorlds, boolean updateConfig) {
        if (this.configWorlds.removeAll(removeWorlds.stream().map(String::toLowerCase).collect(Collectors.toSet()))) {
            if (updateConfig) {
                this.worldGroupManager.updateGroup(this);
            }
            return true;
        }
        return false;
    }

    public void removeAllWorlds() {
        this.removeAllWorlds(true);
    }

    public void removeAllWorlds(boolean updateConfig) {
        this.configWorlds.clear();
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public boolean containsWorld(String worldName) {
        return this.applicableWorlds.contains(worldName.toLowerCase());
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Set<String> getConfigWorlds() {
        return this.configWorlds;
    }

    public Set<String> getApplicableWorlds() {
        return this.applicableWorlds;
    }

    @Deprecated(forRemoval=true, since="5.2")
    public Set<String> getWorlds() {
        return this.applicableWorlds;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void recalculateApplicableWorlds() {
        this.matcherGroup = new MatcherGroup(this.configWorlds);
        this.applicableWorlds = Bukkit.getWorlds().stream().map(WorldInfo::getName).map(String::toLowerCase).filter(arg_0 -> ((MatcherGroup)this.matcherGroup).matches(arg_0)).collect(Collectors.toSet());
    }

    void addApplicableWorld(String worldName) {
        if (this.matcherGroup.matches(worldName.toLowerCase())) {
            this.applicableWorlds.add(worldName.toLowerCase());
        }
    }

    void removeApplicableWorld(String worldName) {
        this.applicableWorlds.remove(worldName.toLowerCase());
    }

    public boolean isSharing(Sharable sharable) {
        return this.getApplicableShares().isSharing(sharable);
    }

    public Shares getShares() {
        return this.shares;
    }

    public Shares getDisabledShares() {
        return this.disabledShares;
    }

    public Shares getApplicableShares() {
        return this.applicableShares;
    }

    public void recalculateApplicableShares() {
        this.applicableShares = Sharables.fromShares(this.shares);
        this.applicableShares.removeAll(this.disabledShares);
        Shares disabledOptionalShares = Sharables.optionalOf();
        disabledOptionalShares.removeAll(this.inventoriesConfig.getActiveOptionalShares());
        this.applicableShares.removeAll(disabledOptionalShares);
        InvLogging.finest("Applicable shares for " + this.getName() + ": " + String.valueOf(this.applicableShares), new Object[0]);
    }

    public String getSpawnWorld() {
        return this.spawnWorld;
    }

    public void setSpawnWorld(String worldName) {
        this.spawnWorld = worldName.toLowerCase();
    }

    public EventPriority getSpawnPriority() {
        return this.spawnPriority;
    }

    public void setSpawnPriority(EventPriority priority) {
        this.spawnPriority = priority;
    }

    public boolean isDefault() {
        return "default".equals(this.getName());
    }

    public ProfileContainer getGroupProfileContainer() {
        return this.profileContainerStoreProvider.getStore(ContainerType.GROUP).getContainer(this.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append(": {Worlds: [");
        String[] worldsString = this.getConfigWorlds().toArray(new String[0]);
        for (int i = 0; i < worldsString.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(worldsString[i]);
        }
        builder.append("], Shares: [").append(this.getShares()).append("]");
        if (this.getSpawnWorld() != null) {
            builder.append(", Spawn World: ").append(this.getSpawnWorld());
            builder.append(", Spawn Priority: ").append(this.getSpawnPriority().toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

