/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.group;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.event.world.MVWorldLoadedEvent;
import org.mvplugins.multiverse.core.event.world.MVWorldUnloadedEvent;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.Tuple2;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.GroupingConflict;
import org.mvplugins.multiverse.inventories.profile.group.GroupingConflictResult;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Contract
abstract class AbstractWorldGroupManager
implements WorldGroupManager {
    static final String DEFAULT_GROUP_NAME = "default";
    protected final Map<String, WorldGroup> groupNamesMap = new LinkedHashMap<String, WorldGroup>();
    protected final MultiverseInventories plugin;
    protected final MVCommandManager commandManager;
    protected final InventoriesConfig inventoriesConfig;
    protected final ProfileContainerStoreProvider profileContainerStoreProvider;
    protected final WorldManager worldManager;

    AbstractWorldGroupManager(@NotNull MultiverseInventories plugin, @NotNull MVCommandManager commandManager, @NotNull InventoriesConfig config, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.commandManager = commandManager;
        this.inventoriesConfig = config;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.worldManager = worldManager;
        Bukkit.getPluginManager().registerEvents((Listener)new WorldChangeListener(), (Plugin)plugin);
    }

    @Override
    public WorldGroup getGroup(String groupName) {
        return this.groupNamesMap.get(groupName.toLowerCase());
    }

    @Override
    public List<WorldGroup> getGroups() {
        return List.copyOf(this.getGroupNames().values());
    }

    @Override
    public List<WorldGroup> getGroupsForWorld(String worldName) {
        worldName = worldName.toLowerCase();
        ArrayList<WorldGroup> worldGroups = new ArrayList<WorldGroup>();
        for (WorldGroup worldGroup : this.getGroupNames().values()) {
            if (!worldGroup.containsWorld(worldName)) continue;
            worldGroups.add(worldGroup);
        }
        if (worldGroups.isEmpty() && this.inventoriesConfig.getDefaultUngroupedWorlds() && this.worldManager.isWorld(worldName)) {
            InvLogging.finer("Returning default group for world: " + worldName, new Object[0]);
            worldGroups.add(this.getDefaultGroup());
        }
        return worldGroups;
    }

    @Override
    public boolean hasConfiguredGroup(String worldName) {
        return this.groupNamesMap.values().stream().anyMatch(worldGroup -> worldGroup.containsWorld(worldName));
    }

    protected Map<String, WorldGroup> getGroupNames() {
        return this.groupNamesMap;
    }

    @Override
    public void updateGroup(WorldGroup worldGroup) {
        this.getGroupNames().put(worldGroup.getName().toLowerCase(), worldGroup);
        worldGroup.recalculateApplicableWorlds();
        worldGroup.recalculateApplicableShares();
    }

    @Override
    public boolean removeGroup(WorldGroup worldGroup) {
        return this.getGroupNames().remove(worldGroup.getName().toLowerCase()) != null;
    }

    @Override
    public WorldGroup newEmptyGroup(String name) {
        if (this.getGroup(name) != null) {
            return null;
        }
        return new WorldGroup(this, this.profileContainerStoreProvider, this.inventoriesConfig, name);
    }

    @Override
    public void createDefaultGroup() {
        if (this.getGroup(DEFAULT_GROUP_NAME) != null) {
            return;
        }
        World defaultWorld = (World)this.worldManager.getDefaultWorld().flatMap(LoadedMultiverseWorld::getBukkitWorld).fold(() -> (World)Bukkit.getWorlds().get(0), world -> world);
        World defaultNether = Bukkit.getWorld((String)(defaultWorld.getName() + "_nether"));
        World defaultEnd = Bukkit.getWorld((String)(defaultWorld.getName() + "_the_end"));
        WorldGroup worldGroup = new WorldGroup(this, this.profileContainerStoreProvider, this.inventoriesConfig, DEFAULT_GROUP_NAME);
        worldGroup.getShares().mergeShares(Sharables.allOf());
        worldGroup.addWorld(defaultWorld);
        if (defaultNether != null) {
            worldGroup.addWorld(defaultNether);
        }
        if (defaultEnd != null) {
            worldGroup.addWorld(defaultEnd);
        }
        this.updateGroup(worldGroup);
        InvLogging.info("Created a default group for you containing all of your default worlds: " + String.join((CharSequence)", ", worldGroup.getConfigWorlds()), new Object[0]);
    }

    @Override
    public WorldGroup getDefaultGroup() {
        WorldGroup group = this.getGroupNames().get(DEFAULT_GROUP_NAME);
        if (group == null) {
            group = this.newEmptyGroup(DEFAULT_GROUP_NAME);
            group.getShares().setSharing(Sharables.allOf(), true);
            this.updateGroup(group);
        }
        return group;
    }

    @Override
    public GroupingConflictResult checkForConflicts() {
        ArrayList<GroupingConflict> conflicts = new ArrayList<GroupingConflict>();
        HashSet<Tuple2<WorldGroup, WorldGroup>> checkedPairs = new HashSet<Tuple2<WorldGroup, WorldGroup>>();
        for (WorldGroup checkingGroup : this.getGroupNames().values()) {
            for (String worldName : checkingGroup.getApplicableWorlds()) {
                for (WorldGroup worldGroup : this.getGroupsForWorld(worldName)) {
                    this.checkConflict(checkingGroup, worldGroup, checkedPairs, conflicts);
                }
            }
        }
        return new GroupingConflictResult(conflicts);
    }

    private void checkConflict(WorldGroup checkingGroup, WorldGroup worldGroup, Set<Tuple2<WorldGroup, WorldGroup>> checkedPairs, List<GroupingConflict> conflicts) {
        if (checkingGroup.equals(worldGroup)) {
            return;
        }
        if (checkedPairs.contains(new Tuple2((Object)checkingGroup, (Object)worldGroup))) {
            return;
        }
        if (checkedPairs.contains(new Tuple2((Object)worldGroup, (Object)checkingGroup))) {
            return;
        }
        InvLogging.finer("Checking conflict between %s and %s", checkingGroup.getName(), worldGroup.getName());
        checkedPairs.add((Tuple2<WorldGroup, WorldGroup>)new Tuple2((Object)checkingGroup, (Object)worldGroup));
        Shares conflictingShares = worldGroup.getApplicableShares().compare(checkingGroup.getApplicableShares());
        if (conflictingShares.isEmpty()) {
            return;
        }
        InvLogging.finer("Conflict found for %s and %s", checkingGroup.getName(), worldGroup.getName());
        conflicts.add(new GroupingConflict(checkingGroup, worldGroup, Sharables.fromShares(conflictingShares)));
    }

    @Override
    public List<GroupingConflict> checkGroups() {
        return this.checkForConflicts().getConflicts();
    }

    @Override
    public void checkForConflicts(MVCommandIssuer issuer) {
        if (issuer == null) {
            issuer = this.commandManager.getCommandIssuer((Object)Bukkit.getConsoleSender());
        }
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_CHECKING);
        GroupingConflictResult groupingConflictResult = this.checkForConflicts();
        if (groupingConflictResult.hasConflict()) {
            groupingConflictResult.sendConflictIssue(issuer);
        } else {
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_NOTFOUND);
        }
    }

    @Override
    public void recalculateApplicableShares() {
        this.getGroupNames().values().forEach(WorldGroup::recalculateApplicableShares);
    }

    @Override
    public void recalculateApplicableWorlds() {
        this.groupNamesMap.values().forEach(WorldGroup::recalculateApplicableWorlds);
    }

    private class WorldChangeListener
    implements Listener {
        private WorldChangeListener() {
        }

        @EventHandler
        void onMVWorldLoad(MVWorldLoadedEvent event) {
            AbstractWorldGroupManager.this.groupNamesMap.values().forEach(group -> group.addApplicableWorld(((LoadedMultiverseWorld)event.getWorld()).getName()));
        }

        @EventHandler
        void onMVWorldUnload(MVWorldUnloadedEvent event) {
            AbstractWorldGroupManager.this.groupNamesMap.values().forEach(group -> group.removeApplicableWorld(event.getWorld().getName()));
        }

        @EventHandler
        void onWorldLoad(WorldLoadEvent event) {
            AbstractWorldGroupManager.this.groupNamesMap.values().forEach(group -> group.addApplicableWorld(event.getWorld().getName()));
        }

        @EventHandler
        void onWorldUnload(WorldUnloadEvent event) {
            AbstractWorldGroupManager.this.groupNamesMap.values().forEach(group -> group.removeApplicableWorld(event.getWorld().getName()));
        }
    }
}

