/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.container;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;

public final class ProfileContainerStore {
    private final Map<String, ProfileContainer> containers = new WeakHashMap<String, ProfileContainer>();
    private final MultiverseInventories inventories;
    private final ContainerType containerType;
    private final ProfileDataSource profileDataSource;

    ProfileContainerStore(MultiverseInventories inventories, ContainerType containerType) {
        this.inventories = inventories;
        this.containerType = containerType;
        this.profileDataSource = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
    }

    public List<String> listContainerDataNames() {
        return this.profileDataSource.listContainerDataNames(this.containerType);
    }

    public ProfileContainer getContainer(String containerName) {
        ProfileContainer container = this.containers.get(containerName.toLowerCase());
        if (container == null) {
            container = new ProfileContainer(this.inventories, containerName, this.containerType);
            this.addContainer(container);
        }
        return container;
    }

    private void addContainer(ProfileContainer container) {
        this.containers.put(container.getContainerName().toLowerCase(), container);
    }
}

