/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.profile.GlobalProfile;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Contract
public interface ProfileDataSource {
    public CompletableFuture<PlayerProfile> getPlayerProfile(ProfileKey var1);

    public CompletableFuture<Void> updatePlayerProfile(PlayerProfile var1);

    public CompletableFuture<Void> deletePlayerProfile(ProfileKey var1);

    public CompletableFuture<Void> deletePlayerProfiles(ProfileFileKey var1, ProfileType[] var2);

    public CompletableFuture<Void> deletePlayerFile(ProfileFileKey var1);

    @ApiStatus.AvailableSince(value="5.3")
    public CompletableFuture<Void> clonePlayerProfiles(ProfileFileKey var1, ProfileFileKey var2, ProfileType[] var3);

    @ApiStatus.AvailableSince(value="5.3")
    public CompletableFuture<Void> clonePlayerFile(ProfileFileKey var1, ProfileFileKey var2);

    public void migratePlayerProfileName(String var1, String var2) throws IOException;

    public CompletableFuture<GlobalProfile> getGlobalProfile(GlobalProfileKey var1);

    public CompletableFuture<Option<GlobalProfile>> getExistingGlobalProfile(GlobalProfileKey var1);

    public CompletableFuture<Void> modifyGlobalProfile(GlobalProfileKey var1, Consumer<GlobalProfile> var2);

    public CompletableFuture<Void> updateGlobalProfile(GlobalProfile var1);

    public CompletableFuture<Void> deleteGlobalProfile(GlobalProfileKey var1, boolean var2);

    public List<String> listContainerDataNames(ContainerType var1);

    public List<String> listPlayerProfileNames(ContainerType var1, String var2);

    public List<UUID> listGlobalProfileUUIDs();
}

