/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import java.nio.file.Path;
import java.util.UUID;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.config.handle.JsonConfigurationHandle;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class GlobalProfile {
    private final UUID uuid;
    private final Nodes nodes;
    private final JsonConfigurationHandle handle;
    private final StringPropertyHandle stringPropertyHandle;

    GlobalProfile(UUID uuid, Path configPath) {
        this.uuid = uuid;
        this.nodes = new Nodes();
        this.handle = JsonConfigurationHandle.builder(configPath, this.nodes.nodes).build();
        this.stringPropertyHandle = new StringPropertyHandle((BaseConfigurationHandle)this.handle);
        this.load();
    }

    Try<Void> load() {
        return this.handle.load().onFailure(e -> InvLogging.severe("Failed to load global profile for player %s: %s", this.uuid, e.getMessage()));
    }

    Try<Void> save() {
        return this.handle.save().onFailure(e -> InvLogging.severe("Failed to save global profile for player %s: %s", this.uuid, e.getMessage()));
    }

    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public String getLastKnownName() {
        return (String)this.handle.get((ValueNode)this.nodes.lastKnownName);
    }

    public Try<Void> setLastKnownName(String lastKnownName) {
        return this.handle.set((ValueNode)this.nodes.lastKnownName, lastKnownName);
    }

    public String getLastWorld() {
        return (String)this.handle.get((ValueNode)this.nodes.lastWorld);
    }

    public Try<Void> setLastWorld(String world) {
        return this.handle.set((ValueNode)this.nodes.lastWorld, world);
    }

    public boolean shouldLoadOnLogin() {
        return (Boolean)this.handle.get((ValueNode)this.nodes.loadOnLogin);
    }

    public Try<Void> setLoadOnLogin(boolean loadOnLogin) {
        return this.handle.set((ValueNode)this.nodes.loadOnLogin, loadOnLogin);
    }

    public String toString() {
        return "GlobalProfile{uuid=" + String.valueOf(this.uuid) + ", lastWorld='" + this.getLastWorld() + "', lastKnownName='" + this.getLastKnownName() + "', loadOnLogin=" + this.shouldLoadOnLogin() + "}";
    }

    private static final class Nodes {
        private final NodeGroup nodes = new NodeGroup();
        private final ConfigNode<String> lastWorld = this.node(ConfigNode.builder((String)"playerData.lastWorld", String.class).defaultValue((Object)"").name("last-world").build());
        private final ConfigNode<String> lastKnownName = this.node(ConfigNode.builder((String)"playerData.lastKnownName", String.class).defaultValue((Object)"").name("last-known-name").build());
        private final ConfigNode<Boolean> loadOnLogin = this.node(ConfigNode.builder((String)"playerData.loadOnLogin", Boolean.class).defaultValue((Object)false).name("load-on-login").build());

        private Nodes() {
        }

        private <N extends Node> N node(N node) {
            this.nodes.add(node);
            return node;
        }
    }
}

