/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import org.bukkit.Bukkit;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.handleshare.PlayerShareHandlingState;
import org.mvplugins.multiverse.inventories.listeners.AdvancementDonePaperHelper;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class SilentGrantsListener
implements MVInvListener {
    private final PlayerShareHandlingState playerShareHandlingState;
    private final boolean hasShouldShowNotificationMethod;
    private final boolean hasPlayerAdvancementDoneMessageMethod;

    @Inject
    SilentGrantsListener(PlayerShareHandlingState playerShareHandlingState) {
        this.playerShareHandlingState = playerShareHandlingState;
        this.hasShouldShowNotificationMethod = ReflectHelper.getMethod(PlayerRecipeDiscoverEvent.class, (String)"shouldShowNotification", (Class[])new Class[0]) != null;
        boolean bl = this.hasPlayerAdvancementDoneMessageMethod = ReflectHelper.getMethod(PlayerAdvancementDoneEvent.class, (String)"message", (Class[])new Class[0]) != null;
        if (this.hasPlayerAdvancementDoneMessageMethod && Bukkit.getPluginManager().isPluginEnabled("DiscordSRV")) {
            InvLogging.fine("Registering DiscordSRV advancement grant hook.", new Object[0]);
            AdvancementDonePaperHelper.getInstance().registerDiscordSrvHook();
        }
    }

    @EventMethod
    void onPlayerRecipeDiscover(PlayerRecipeDiscoverEvent event) {
        if (!this.hasShouldShowNotificationMethod) {
            return;
        }
        if (this.playerShareHandlingState.isHandlingSharable(event.getPlayer(), Sharables.RECIPES)) {
            InvLogging.finest("Suppressing recipe discover notification for player %s due to share handling.", event.getPlayer().getName());
            event.shouldShowNotification(false);
        }
    }

    @EventMethod
    void onPlayerAdvancementDone(PlayerAdvancementDoneEvent event) {
        if (!this.hasPlayerAdvancementDoneMessageMethod) {
            return;
        }
        if (this.playerShareHandlingState.isHandlingSharable(event.getPlayer(), Sharables.ADVANCEMENTS)) {
            AdvancementDonePaperHelper.getInstance().handleAdvancementDoneEventSuppression(event);
        }
    }

    @EventMethod
    void onPluginEnable(PluginEnableEvent event) {
        if (this.hasPlayerAdvancementDoneMessageMethod && event.getPlugin().getName().equals("DiscordSRV")) {
            InvLogging.fine("Registering DiscordSRV advancement grant hook.", new Object[0]);
            AdvancementDonePaperHelper.getInstance().registerDiscordSrvHook();
        }
    }
}

