/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.dataimport.DataImporter;

@Service
public final class DataImportManager
implements Listener {
    private final Map<String, DataImporter> dataImporters = new HashMap<String, DataImporter>();

    @Inject
    DataImportManager(@NotNull MultiverseInventories inventories, @NotNull PluginManager pluginManager) {
        pluginManager.registerEvents((Listener)this, (Plugin)inventories);
    }

    public void register(DataImporter dataImporter, boolean tryEnable) {
        this.dataImporters.put(dataImporter.getPluginName().toLowerCase(), dataImporter);
        if (tryEnable) {
            dataImporter.enable();
        }
    }

    public void register(DataImporter dataImporter) {
        this.register(dataImporter, true);
    }

    public Option<DataImporter> getImporter(String pluginName) {
        return Option.of((Object)this.dataImporters.get(pluginName.toLowerCase()));
    }

    public Option<DataImporter> getImporter(Plugin plugin) {
        return this.getImporter(plugin.getName());
    }

    public Collection<String> getEnabledImporterNames() {
        return this.dataImporters.values().stream().filter(DataImporter::isEnabled).map(DataImporter::getPluginName).collect(Collectors.toList());
    }

    @EventHandler
    private void pluginEnable(PluginEnableEvent event) {
        this.getImporter(event.getPlugin()).peek(dataImporter -> dataImporter.enable(event.getPlugin()));
    }

    @EventHandler
    private void pluginDisable(PluginDisableEvent event) {
        this.getImporter(event.getPlugin()).peek(DataImporter::disable);
    }
}

