/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.config.handle;

import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.mvplugins.multiverse.core.config.handle.FileConfigurationHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.utils.configuration.json.JsonConfiguration;

public class JsonConfigurationHandle
extends FileConfigurationHandle<JsonConfiguration> {
    @NotNull
    public static Builder<? extends Builder> builder(@NotNull Path configPath, @NotNull NodeGroup nodes) {
        return new Builder(configPath, nodes);
    }

    protected JsonConfigurationHandle(@NotNull Path configPath, @Nullable Logger logger, @NotNull NodeGroup nodes, @Nullable ConfigMigrator migrator) {
        super(configPath, logger, nodes, migrator);
    }

    protected void loadConfigObject() throws IOException, InvalidConfigurationException {
        this.config = new JsonConfiguration();
        ((JsonConfiguration)this.config).load(this.configFile);
    }

    public Try<Void> save() {
        return Try.run(() -> {
            this.config = new JsonConfiguration();
        }).flatMap(ignore -> super.save()).andThenTry(ignore -> ((JsonConfiguration)this.config).save(this.configFile));
    }

    public static class Builder<B extends Builder<B>>
    extends FileConfigurationHandle.Builder<JsonConfiguration, B> {
        protected Builder(@NotNull Path configPath, @NotNull NodeGroup nodes) {
            super(configPath, nodes);
        }

        @NotNull
        public JsonConfigurationHandle build() {
            return new JsonConfigurationHandle(this.configPath, this.logger, this.nodes, this.migrator);
        }
    }
}

