/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.bulkedit.BulkEditCommand;
import org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile.IncludeGroupsWorldsFlag;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditCreator;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

@Service
public class ClonePlayerCommand
extends BulkEditCommand {
    @NotNull
    private final CommandQueueManager commandQueueManager;
    @NotNull
    private final IncludeGroupsWorldsFlag flags;

    @Inject
    ClonePlayerCommand(@NotNull BulkEditCreator bulkEditCreator, @NotNull CommandQueueManager commandQueueManager, @NotNull IncludeGroupsWorldsFlag flags) {
        super(bulkEditCreator);
        this.commandQueueManager = commandQueueManager;
        this.flags = flags;
    }

    @Subcommand(value="bulkedit playerprofile clone-player")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    @CommandCompletion(value="@mvinvplayername @mvinvplayername @mvinvcontainerkeys @mvinvprofiletypes:multiple @flags:groupName=mvinvincludegroupsworlds")
    @Syntax(value="<from-player> <to-player> <groups/worlds> [profile-types] [--include-groups-worlds]")
    void onCommand(MVCommandIssuer issuer, @Syntax(value="<from-player>") GlobalProfileKey fromPlayer, @Syntax(value="<to-player>") GlobalProfileKey[] toPlayers, @Syntax(value="<groups/worlds>") ContainerKey[] containerKeys, @Syntax(value="[profile-types]") ProfileType[] profileTypes, @Syntax(value="[--include-groups-worlds]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        BulkEditAction<?> bulkEditAction = this.bulkEditCreator.playerProfileClonePlayer(fromPlayer, new PlayerProfilesPayload(toPlayers, containerKeys, profileTypes, parsedFlags.hasFlag(this.flags.includeGroupsWorlds)));
        this.outputActionSummary(issuer, bulkEditAction);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to clone profiles from %s to %s for the selected groups/worlds?".formatted(fromPlayer.getPlayerName(), toPlayers.length == 1 ? toPlayers[0].getPlayerName() : toPlayers.length + " players"), (MessageReplacement[])new MessageReplacement[0])).action(() -> this.runBulkEditAction(issuer, bulkEditAction)));
    }
}

