/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.globalprofile;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.bulkedit.BulkEditCommand;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditCreator;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;

@Service
final class ClearCommand
extends BulkEditCommand {
    private final CommandQueueManager commandQueueManager;
    private final Flags flags;

    @Inject
    ClearCommand(@NotNull BulkEditCreator bulkEditCreator, @NotNull CommandQueueManager commandQueueManager, @NotNull Flags flags) {
        super(bulkEditCreator);
        this.commandQueueManager = commandQueueManager;
        this.flags = flags;
    }

    @Subcommand(value="bulkedit globalprofile clear")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    @CommandCompletion(value="@mvinvplayernames @flags:groupName=mvinvbulkeditglobalprofileclear")
    @Syntax(value="<players> [--clear-all-player-profiles]")
    void onCommand(MVCommandIssuer issuer, @Syntax(value="<players>") GlobalProfileKey[] globalProfileKeys, @Syntax(value="[--clear-all-playerprofiles]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        BulkEditAction<?> bulkEditAction = this.bulkEditCreator.globalProfileClear(globalProfileKeys, parsedFlags.hasFlag(this.flags.clearAllPlayerProfiles));
        this.outputActionSummary(issuer, bulkEditAction);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to clear the selected global profiles?", (MessageReplacement[])new MessageReplacement[0])).action(() -> this.runBulkEditAction(issuer, bulkEditAction)));
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvinvbulkeditglobalprofileclear";
        private final CommandFlag clearAllPlayerProfiles = this.flag(CommandFlag.builder((String)"--clear-all-player-profiles").addAlias(new String[]{"-a"}).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }
}

