/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.dataimport.DataImportManager;
import org.mvplugins.multiverse.inventories.dataimport.DataImporter;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class MigrateCommand
extends InventoriesCommand {
    private final DataImportManager dataImportManager;
    private final CommandQueueManager commandQueueManager;

    @Inject
    MigrateCommand(@NotNull DataImportManager dataImportManager, @NotNull CommandQueueManager commandQueueManager) {
        this.dataImportManager = dataImportManager;
        this.commandQueueManager = commandQueueManager;
    }

    @Subcommand(value="migrate")
    @Syntax(value="<MultiInv|WorldInventories|PerWorldInventory>")
    @CommandPermission(value="multiverse.inventories.migrate")
    @CommandCompletion(value="@dataimporters")
    @Description(value="Import inventories from MultiInv/WorldInventories/PerWorldInventory plugin.")
    void onMigrateCommand(MVCommandIssuer issuer, @Single @Syntax(value="<MultiInv|WorldInventories|PerWorldInventory>") String pluginName) {
        if (this.dataImportManager.getEnabledImporterNames().isEmpty()) {
            issuer.sendError("Please install Multiverse-InventoriesImporter plugin to use this command.", new MessageReplacement[0]);
            issuer.sendInfo("Download Link: https://modrinth.com/project/multiverse-inventoriesimporter/", new MessageReplacement[0]);
            issuer.sendInfo("Learn More: https://mvplugins.org/inventories/how-to/import-playerdata/", new MessageReplacement[0]);
            return;
        }
        this.dataImportManager.getImporter(pluginName).onEmpty(() -> issuer.sendError((MessageKeyProvider)MVInvi18n.MIGRATE_UNSUPPORTEDPLUGIN, new MessageReplacement[]{MessageReplacement.replace((String)"{plugin}").with((Object)pluginName)})).peek(dataImporter -> {
            if (!dataImporter.isEnabled()) {
                issuer.sendError((MessageKeyProvider)MVInvi18n.MIGRATE_PLUGINNOTENABLED, new MessageReplacement[]{MessageReplacement.replace((String)"{plugin}").with((Object)pluginName)});
                return;
            }
            this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt((Message)Message.of((MessageKeyProvider)MVInvi18n.MIGRATE_CONFIRMPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{plugin}").with((Object)pluginName)})).action(() -> this.doDataImport(issuer, (DataImporter)dataImporter)));
        });
    }

    void doDataImport(MVCommandIssuer issuer, DataImporter dataImporter) {
        if (dataImporter.importData()) {
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.MIGRATE_SUCCESS, new MessageReplacement[]{MessageReplacement.replace((String)"{plugin}").with((Object)dataImporter.getPluginName())});
        } else {
            issuer.sendError((MessageKeyProvider)MVInvi18n.MIGRATE_FAILED, new MessageReplacement[]{MessageReplacement.replace((String)"{plugin}").with((Object)dataImporter.getPluginName())});
        }
    }
}

