/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_5.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_5.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import org.bukkit.entity.EntityType;

public class FrogAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", FrogAttributes.getFrogVariantRegistry().listElementIds().map(id -> id.location().getPath()).toList(), List.of(EntityType.FROG), FrogAttributes::setVariant));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        Frog frog = (Frog)ReflectionHelper.getEntity(npc);
        Holder variant = (Holder)FrogAttributes.getFrogVariantRegistry().get(ResourceKey.create((ResourceKey)Registries.FROG_VARIANT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)value.toLowerCase()))).orElseThrow();
        frog.setVariant(variant);
    }

    private static HolderLookup.RegistryLookup<FrogVariant> getFrogVariantRegistry() {
        return MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.FROG_VARIANT);
    }
}

