/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_11.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_11.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.animal.parrot.Parrot;
import org.bukkit.entity.EntityType;

public class ParrotAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", Arrays.stream(Parrot.Variant.values()).map(Enum::name).toList(), List.of(EntityType.PARROT), ParrotAttributes::setVariant));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting"), List.of(EntityType.PARROT), ParrotAttributes::setPose));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        Parrot parrot = (Parrot)ReflectionHelper.getEntity(npc);
        Parrot.Variant variant = Parrot.Variant.valueOf((String)value.toUpperCase());
        parrot.setVariant(variant);
    }

    private static void setPose(Npc npc, String value) {
        Parrot parrot = (Parrot)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                parrot.setOrderedToSit(false);
                parrot.setInSittingPose(false, false);
                break;
            }
            case "sitting": {
                parrot.setOrderedToSit(true);
                parrot.setInSittingPose(true, false);
            }
        }
    }
}

