/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_6.attributes;

import de.oliver.fancylib.ReflectionUtils;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_6.MappingKeys1_20_6;
import de.oliver.fancynpcs.v1_20_6.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.animal.Panda;
import org.bukkit.entity.EntityType;

public class PandaAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("gene", Arrays.stream(Panda.Gene.values()).map(Enum::name).toList(), List.of(EntityType.PANDA), PandaAttributes::setGene));
        attributes.add(new NpcAttribute("eating", List.of("true", "false"), List.of(EntityType.PANDA), PandaAttributes::setEating));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting", "onBack", "rolling"), List.of(EntityType.PANDA), PandaAttributes::setPose));
        return attributes;
    }

    private static void setGene(Npc npc, String value) {
        Panda panda = (Panda)ReflectionHelper.getEntity(npc);
        Panda.Gene gene = Panda.Gene.valueOf((String)value.toUpperCase());
        panda.setMainGene(gene);
    }

    private static void setPose(Npc npc, String value) {
        Panda panda = (Panda)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.roll(false);
                panda.setOnBack(false);
                break;
            }
            case "sitting": {
                panda.roll(false);
                panda.setOnBack(false);
                PandaAttributes.setFlag(panda, 8, true);
                break;
            }
            case "onback": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.roll(false);
                panda.setOnBack(true);
                break;
            }
            case "rolling": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.setOnBack(false);
                panda.roll(true);
            }
        }
    }

    private static void setEating(Npc npc, String value) {
        Panda panda = (Panda)ReflectionHelper.getEntity(npc);
        boolean eating = Boolean.parseBoolean(value);
        panda.eat(eating);
    }

    private static void setFlag(Panda panda, int mask, boolean value) {
        EntityDataAccessor DATA_ID_FLAGS = (EntityDataAccessor)ReflectionUtils.getValue(panda, MappingKeys1_20_6.PANDA__DATA_ID_FLAGS.getMapping());
        byte b0 = (Byte)panda.getEntityData().get(DATA_ID_FLAGS);
        if (value) {
            panda.getEntityData().set(DATA_ID_FLAGS, (Object)((byte)(b0 | mask)));
        } else {
            panda.getEntityData().set(DATA_ID_FLAGS, (Object)((byte)(b0 & ~mask)));
        }
    }
}

