/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_1.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_1.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.item.EnumColor;
import org.bukkit.entity.EntityType;

public class WolfAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting"), List.of(EntityType.WOLF), WolfAttributes::setPose));
        attributes.add(new NpcAttribute("angry", List.of("true", "false"), List.of(EntityType.WOLF), WolfAttributes::setAngry));
        attributes.add(new NpcAttribute("collar_color", List.of("RED", "BLUE", "YELLOW", "GREEN", "PURPLE", "ORANGE", "LIME", "MAGENTA", "BROWN", "WHITE", "GRAY", "LIGHT_GRAY", "LIGHT_BLUE", "BLACK", "CYAN", "PINK", "NONE"), List.of(EntityType.WOLF), WolfAttributes::setCollarColor));
        return attributes;
    }

    private static void setPose(Npc npc, String value) {
        EntityWolf wolf = (EntityWolf)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                wolf.setInSittingPose(false, false);
                break;
            }
            case "sitting": {
                wolf.setInSittingPose(true, false);
            }
        }
    }

    private static void setAngry(Npc npc, String value) {
        EntityWolf wolf = (EntityWolf)ReflectionHelper.getEntity(npc);
        boolean angry = Boolean.parseBoolean(value.toLowerCase());
        wolf.a(angry ? 100 : 0);
    }

    private static void setCollarColor(Npc npc, String value) {
        EntityWolf wolf = (EntityWolf)ReflectionHelper.getEntity(npc);
        if (value.equalsIgnoreCase("none") || value.isEmpty()) {
            wolf.x(false);
            return;
        }
        try {
            EnumColor color = EnumColor.valueOf((String)value.toUpperCase());
            if (!wolf.q()) {
                wolf.x(true);
            }
            wolf.a(color);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid wolf collar color: " + value);
        }
    }
}

