/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins.uuidcache;

import com.google.gson.Gson;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.skins.uuidcache.MinecraftUsercacheData;
import de.oliver.fancynpcs.skins.uuidcache.UUIDCache;
import de.oliver.fancynpcs.skins.uuidcache.UUIDCacheData;
import de.oliver.jdb.JDB;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UUIDFileCache
implements UUIDCache {
    private static final File usercacheFile = new File("usercache.json");
    private static final Gson gson = new Gson();
    private final JDB storage = new JDB("plugins/FancyNpcs/.data");
    private final Map<String, UUIDCacheData> cache = new ConcurrentHashMap<String, UUIDCacheData>();
    private final Map<String, UUID> minecraftUsercache = new ConcurrentHashMap<String, UUID>();

    public UUIDFileCache() {
        this.loadMinecraftUsercache();
        this.load();
    }

    private void load() {
        UUIDCacheData[] uuids;
        try {
            uuids = this.storage.get("uuids", UUIDCacheData[].class);
        }
        catch (IOException e) {
            FancyNpcs.getInstance().getFancyLogger().error("Failed to load UUID cache", ThrowableProperty.of(e));
            return;
        }
        if (uuids == null) {
            return;
        }
        this.cache.clear();
        for (UUIDCacheData data : uuids) {
            if (data.isExpired()) continue;
            this.cache.put(data.username(), data);
        }
        FancyNpcs.getInstance().getFancyLogger().debug("Loaded " + this.cache.size() + " UUIDs from file cache", new Property[0]);
    }

    private void loadMinecraftUsercache() {
        MinecraftUsercacheData[] data;
        if (!FancyNpcs.USE_MINECRAFT_USERCACHE_FEATURE_FLAG.isEnabled()) {
            return;
        }
        if (!usercacheFile.exists()) {
            FancyNpcs.getInstance().getFancyLogger().debug("Minecraft usercache file does not exist, skipping load.", new Property[0]);
            return;
        }
        try {
            data = gson.fromJson((Reader)new FileReader(usercacheFile), MinecraftUsercacheData[].class);
        }
        catch (FileNotFoundException e) {
            FancyNpcs.getInstance().getFancyLogger().error("Failed to load Minecraft usercache file", new Property[0]);
            return;
        }
        if (data == null) {
            return;
        }
        for (MinecraftUsercacheData d : data) {
            this.minecraftUsercache.put(d.name(), UUID.fromString(d.uuid()));
        }
        FancyNpcs.getInstance().getFancyLogger().debug("Loaded " + this.minecraftUsercache.size() + " UUIDs from Minecraft usercache", new Property[0]);
    }

    private void save() {
        UUIDCacheData[] uuids = this.cache.values().toArray(new UUIDCacheData[0]);
        try {
            this.storage.set("uuids", uuids);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save UUID cache", e);
        }
    }

    @Override
    public UUID getUUID(String username) {
        if (this.minecraftUsercache.containsKey(username)) {
            FancyNpcs.getInstance().getFancyLogger().debug("Found UUID for " + username + ": " + String.valueOf(this.minecraftUsercache.get(username)) + " in Minecraft usercache", new Property[0]);
            return this.minecraftUsercache.get(username);
        }
        if (this.cache.isEmpty()) {
            this.load();
        }
        if (!this.cache.containsKey(username)) {
            return null;
        }
        UUIDCacheData data = this.cache.get(username);
        if (data.isExpired()) {
            this.cache.remove(username);
            this.save();
            return null;
        }
        FancyNpcs.getInstance().getFancyLogger().debug("Found UUID for " + username + ": " + String.valueOf(data.uuid()) + " in file cache", new Property[0]);
        return data.uuid();
    }

    @Override
    public void cacheUUID(String username, UUID uuid) {
        UUIDCacheData data = new UUIDCacheData(username, uuid, System.currentTimeMillis(), 2592000000L);
        this.cache.put(username, data);
        this.save();
        FancyNpcs.getInstance().getFancyLogger().debug("Cached UUID for " + username + ": " + String.valueOf(uuid), new Property[0]);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        this.storage.delete("uuids");
    }
}

