/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins.mineskin;

import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.skins.mineskin.RatelimitException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.mineskin.JsoupRequestHandler;
import org.mineskin.MineSkinClient;
import org.mineskin.data.CodeAndMessage;
import org.mineskin.data.JobReference;
import org.mineskin.data.SkinInfo;
import org.mineskin.exception.MineSkinRequestException;
import org.mineskin.request.GenerateRequest;
import org.mineskin.response.MineSkinResponse;
import org.mineskin.response.QueueResponse;

public class MineSkinAPI {
    private final MineSkinClient client;

    public MineSkinAPI(ScheduledExecutorService executor) {
        this.client = MineSkinClient.builder().requestHandler(JsoupRequestHandler::new).apiKey(FancyNpcs.getInstance().getFancyNpcConfig().getMineSkinApiKey()).userAgent("FancyNpcs").timeout(3000).getExecutor(executor).generateExecutor(executor).generateRequestScheduler(executor).generateRequestScheduler(executor).jobCheckScheduler(executor).build();
    }

    public SkinInfo generateSkin(GenerateRequest req) throws RatelimitException {
        block19: {
            FancyNpcs.getInstance().getFancyLogger().debug("Generating a skin with MineSkinAPI...", new Property[0]);
            QueueResponse queueResp = null;
            JobReference jobResp = null;
            try {
                queueResp = this.client.queue().submit(req).get();
                if (queueResp.getRateLimit().limit().remaining() == 0) {
                    throw new RatelimitException(System.currentTimeMillis() + 10000L);
                }
                jobResp = queueResp.getJob().waitForCompletion(this.client).get();
                SkinInfo skinInfo = jobResp.getOrLoadSkin(this.client).get();
                FancyNpcs.getInstance().getFancyLogger().debug("Skin generated with MineSkinApi: " + skinInfo.toString(), new Property[0]);
                return skinInfo;
            }
            catch (RatelimitException e) {
                throw e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MineSkinRequestException) {
                    MineSkinRequestException requestException = (MineSkinRequestException)cause;
                    MineSkinResponse<?> response = requestException.getResponse();
                    for (CodeAndMessage error : response.getErrors()) {
                        if (error.code().equals("rate_limit")) {
                            throw new RatelimitException(System.currentTimeMillis() + 10000L);
                        }
                        FancyNpcs.getInstance().getFancyLogger().warn("Could not fetch skin: " + error.code() + ": " + error.message(), new Property[0]);
                        if (queueResp != null) {
                            FancyNpcs.getInstance().getFancyLogger().debug("QueueResp: " + String.valueOf(queueResp), new Property[0]);
                        }
                        if (jobResp == null) continue;
                        FancyNpcs.getInstance().getFancyLogger().debug("JobResp: " + String.valueOf(jobResp), new Property[0]);
                    }
                } else {
                    if (cause instanceof SocketTimeoutException) {
                        SocketTimeoutException timeoutException = (SocketTimeoutException)cause;
                        FancyNpcs.getInstance().getFancyLogger().warn("Timeout while fetching skin: " + timeoutException.getMessage(), new Property[0]);
                        if (queueResp != null) {
                            FancyNpcs.getInstance().getFancyLogger().debug("QueueResp: " + String.valueOf(queueResp), new Property[0]);
                        }
                        if (jobResp != null) {
                            FancyNpcs.getInstance().getFancyLogger().debug("JobResp: " + String.valueOf(jobResp), new Property[0]);
                        }
                        throw new RatelimitException(System.currentTimeMillis() + 10000L);
                    }
                    FancyNpcs.getInstance().getFancyLogger().error("Error in mineskin request: " + cause.getMessage(), new Property[0]);
                    if (queueResp != null) {
                        FancyNpcs.getInstance().getFancyLogger().debug("QueueResp: " + String.valueOf(queueResp), new Property[0]);
                    }
                    if (jobResp != null) {
                        FancyNpcs.getInstance().getFancyLogger().debug("JobResp: " + String.valueOf(jobResp), new Property[0]);
                    }
                }
            }
            catch (InterruptedException e) {
                FancyNpcs.getInstance().getFancyLogger().error("Thread was interrupted while waiting for skin generation.", new Property[0]);
                if (queueResp != null) {
                    FancyNpcs.getInstance().getFancyLogger().debug("QueueResp: " + String.valueOf(queueResp), new Property[0]);
                }
                if (jobResp != null) {
                    FancyNpcs.getInstance().getFancyLogger().debug("JobResp: " + String.valueOf(jobResp), new Property[0]);
                }
            }
            catch (Exception e) {
                FancyNpcs.getInstance().getFancyLogger().error("Unexpected error in skin generation: " + e.getMessage(), new Property[0]);
                if (queueResp != null) {
                    FancyNpcs.getInstance().getFancyLogger().debug("QueueResp: " + String.valueOf(queueResp), new Property[0]);
                }
                if (jobResp == null) break block19;
                FancyNpcs.getInstance().getFancyLogger().debug("JobResp: " + String.valueOf(jobResp), new Property[0]);
            }
        }
        return null;
    }
}

