/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.api.utils;

import java.time.Instant;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Interval {
    private final long value;

    public Interval(long value) {
        this.value = value;
    }

    @NotNull
    public static Interval now() {
        return new Interval(System.currentTimeMillis());
    }

    @NotNull
    public static Interval of(long interval, @NotNull Unit unit) {
        return new Interval(interval * unit.factor);
    }

    @NotNull
    public static Interval of(double interval, @NotNull Unit unit) {
        return new Interval(Math.round(interval * (double)unit.factor));
    }

    @NotNull
    public static Interval between(long n, long m4, @NotNull Unit unit) {
        return new Interval((n - m4) * unit.factor);
    }

    @NotNull
    public static Interval between(double n, double m4, @NotNull Unit unit) {
        return new Interval(Math.round((n - m4) * (double)unit.factor));
    }

    public double as(@NotNull Unit unit) {
        return this.value / unit.factor;
    }

    @NotNull
    public Interval add(@NotNull Interval other) {
        return new Interval(this.value + other.value);
    }

    @NotNull
    public Interval add(long n, @NotNull Unit unit) {
        return new Interval(this.value + n * unit.factor);
    }

    @NotNull
    public Interval remove(@NotNull Interval other) {
        return new Interval(this.value - other.value);
    }

    @NotNull
    public Interval remove(long n, @NotNull Unit unit) {
        return new Interval(this.value - n * unit.factor);
    }

    @NotNull
    public Date toDate() {
        return new Date(this.value);
    }

    @NotNull
    public Instant toInstant() {
        return Instant.ofEpochMilli(this.value);
    }

    @NotNull
    public String toString() {
        if (this.value < 1000L) {
            return this.value % Unit.YEARS.getFactor() % Unit.MONTHS.getFactor() % Unit.DAYS.getFactor() % Unit.HOURS.getFactor() % Unit.MINUTES.getFactor() % Unit.SECONDS.getFactor() / Unit.MILLISECONDS.getFactor() + "ms";
        }
        long years = this.value / Unit.YEARS.getFactor();
        long months = this.value % Unit.YEARS.getFactor() / Unit.MONTHS.getFactor();
        long days = this.value % Unit.YEARS.getFactor() % Unit.MONTHS.getFactor() / Unit.DAYS.getFactor();
        long hours = this.value % Unit.YEARS.getFactor() % Unit.MONTHS.getFactor() % Unit.DAYS.getFactor() / Unit.HOURS.getFactor();
        long minutes = this.value % Unit.YEARS.getFactor() % Unit.MONTHS.getFactor() % Unit.DAYS.getFactor() % Unit.HOURS.getFactor() / Unit.MINUTES.getFactor();
        long seconds = this.value % Unit.YEARS.getFactor() % Unit.MONTHS.getFactor() % Unit.DAYS.getFactor() % Unit.HOURS.getFactor() % Unit.MINUTES.getFactor() / Unit.SECONDS.getFactor();
        StringBuilder builder = new StringBuilder();
        if (years > 0L) {
            builder.append(years).append("y ");
        }
        if (months > 0L) {
            builder.append(months).append("mo ");
        }
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L) {
            builder.append(hours).append("h ");
        }
        if (minutes > 0L) {
            builder.append(minutes).append("min ");
        }
        if (seconds > 0L) {
            builder.append(seconds).append("s");
        }
        if (builder.charAt(builder.length() - 1) == ' ') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static enum Unit {
        MILLISECONDS(1L, "ms"),
        TICKS(50L, "t"),
        SECONDS(1000L, "s"),
        MINUTES(60000L, "min"),
        HOURS(3600000L, "h"),
        DAYS(86400000L, "d"),
        MONTHS(2629800000L, "mo"),
        YEARS(31557600000L, "y");

        private final long factor;
        private final String shortCode;

        private Unit(long factor, String shortCode) {
            this.factor = factor;
            this.shortCode = shortCode;
        }

        @Nullable
        public static Unit fromShortCode(@NotNull String shortCode) {
            for (Unit unit : Unit.values()) {
                if (!unit.shortCode.equalsIgnoreCase(shortCode)) continue;
                return unit;
            }
            return null;
        }

        public long getFactor() {
            return this.factor;
        }

        @NotNull
        public String getShortCode() {
            return this.shortCode;
        }
    }
}

