/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.cloud.annotations.parser;

import de.oliver.cloud.annotations.method.AnnotatedMethodHandler;
import de.oliver.cloud.annotations.method.ParameterValue;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.cloud.injection.ParameterInjectorRegistry;
import de.oliver.cloud.parser.ArgumentParseResult;
import de.oliver.cloud.parser.ArgumentParser;
import de.oliver.cloud.suggestion.SuggestionProvider;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MethodArgumentParser<C, T>
extends AnnotatedMethodHandler<C>
implements ArgumentParser<C, T> {
    private final SuggestionProvider<C> suggestionProvider;

    public MethodArgumentParser(@NonNull SuggestionProvider<C> suggestionProvider, @NonNull Object instance, @NonNull Method method, @NonNull ParameterInjectorRegistry<C> injectorRegistry) {
        super(method, instance, injectorRegistry);
        this.suggestionProvider = suggestionProvider;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        List arguments = this.createParameterValues(commandContext, this.parameters(), Collections.singletonList(commandInput)).stream().map(ParameterValue::value).collect(Collectors.toList());
        try {
            return ArgumentParseResult.success(this.methodHandle().invokeWithArguments(arguments));
        }
        catch (Throwable t2) {
            return ArgumentParseResult.failure(t2);
        }
    }

    @Override
    public @NonNull SuggestionProvider<C> suggestionProvider() {
        return this.suggestionProvider;
    }
}

