/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.manifest.impl;

import ca.solostudios.strata.Versions;
import ca.solostudios.strata.version.Version;
import ca.solostudios.strata.version.VersionRange;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.tectonic.api.loader.ConfigLoader;
import com.dfsek.tectonic.api.loader.type.TypeLoader;
import com.dfsek.tectonic.yaml.YamlConfiguration;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.addons.manifest.impl.ManifestAddon;
import com.dfsek.terra.addons.manifest.impl.config.AddonManifest;
import com.dfsek.terra.addons.manifest.impl.config.WebsiteConfig;
import com.dfsek.terra.addons.manifest.impl.config.loaders.VersionLoader;
import com.dfsek.terra.addons.manifest.impl.config.loaders.VersionRangeLoader;
import com.dfsek.terra.addons.manifest.impl.exception.AddonException;
import com.dfsek.terra.addons.manifest.impl.exception.ManifestException;
import com.dfsek.terra.addons.manifest.impl.exception.ManifestNotPresentException;
import com.dfsek.terra.api.addon.bootstrap.BootstrapAddonClassLoader;
import com.dfsek.terra.api.addon.bootstrap.BootstrapBaseAddon;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestAddonLoader
implements BootstrapBaseAddon<ManifestAddon> {
    private static final Logger logger = LoggerFactory.getLogger(ManifestAddonLoader.class);
    private static final Version VERSION = Versions.getVersion((int)1, (int)0, (int)0);
    private final ConfigLoader manifestLoader = ((ConfigLoader)((ConfigLoader)new ConfigLoader().registerLoader((Type)((Object)Version.class), (TypeLoader)new VersionLoader())).registerLoader((Type)((Object)VersionRange.class), (TypeLoader)new VersionRangeLoader())).registerLoader((Type)((Object)WebsiteConfig.class), WebsiteConfig::new);

    /*
     * Enabled aggressive exception aggregation
     */
    public ManifestAddon loadAddon(Path addonPath, ClassLoader loader) {
        try (JarFile jar = new JarFile(addonPath.toFile());){
            logger.debug("Loading addon from JAR {}", (Object)addonPath);
            JarEntry manifestEntry = jar.getJarEntry("terra.addon.yml");
            if (manifestEntry == null) {
                throw new ManifestNotPresentException("Addon " + addonPath + " does not contain addon manifest.");
            }
            try {
                AddonManifest manifest = this.manifestLoader.load(new AddonManifest(), new YamlConfiguration(jar.getInputStream(manifestEntry), "terra.addon.yml"));
                logger.debug("Loading addon {}@{}", (Object)manifest.getID(), (Object)manifest.getVersion().getFormatted());
                if (manifest.getSchemaVersion() != 1) {
                    throw new AddonException("Addon " + manifest.getID() + " has unknown schema version: " + manifest.getSchemaVersion());
                }
                List<AddonInitializer> initializers = manifest.getEntryPoints().stream().map(entryPoint -> {
                    try {
                        Object in = loader.loadClass((String)entryPoint).getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!(in instanceof AddonInitializer)) {
                            throw new AddonException(in.getClass() + " does not extend " + AddonInitializer.class);
                        }
                        return (AddonInitializer)in;
                    }
                    catch (InvocationTargetException e) {
                        throw new AddonException("Exception occurred while instantiating addon", e);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                        throw new AddonException(String.format("No valid default constructor found in entry point %s", entryPoint), e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new AddonException(String.format("Entry point %s not found in JAR.", entryPoint), e);
                    }
                }).collect(Collectors.toList());
                ManifestAddon manifestAddon = new ManifestAddon(manifest, initializers);
                return manifestAddon;
            }
            catch (LoadException e) {
                throw new ManifestException("Failed to load addon manifest", e);
            }
        }
        catch (IOException e) {
            throw new AddonException("Failed to load addon from JAR " + addonPath, e);
        }
    }

    public Iterable<ManifestAddon> loadAddons(Path addonsFolder, BootstrapAddonClassLoader parent) {
        Iterable iterable;
        block8: {
            logger.debug("Loading addons...");
            Stream<Path> files = Files.walk(addonsFolder, 1, FileVisitOption.FOLLOW_LINKS);
            try {
                List<Path> addons = files.filter(path -> path.toFile().isFile()).filter(path -> path.toFile().canRead()).filter(path -> !path.getFileName().startsWith(".")).filter(path -> path.toString().endsWith(".jar")).toList();
                addons.stream().map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new UncheckedIOException(e);
                    }
                }).forEach(arg_0 -> ((BootstrapAddonClassLoader)parent).addURL(arg_0));
                iterable = addons.stream().map(jar -> this.loadAddon((Path)jar, (ClassLoader)parent)).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            files.close();
        }
        return iterable;
    }

    public String getID() {
        return "MANIFEST";
    }

    public Version getVersion() {
        return VERSION;
    }
}

