/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.manifest.impl;

import ca.solostudios.strata.version.Version;
import ca.solostudios.strata.version.VersionRange;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.addons.manifest.impl.config.AddonManifest;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.inject.Injector;
import com.dfsek.terra.api.inject.annotations.Inject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestAddon
implements BaseAddon {
    private static final Logger logger = LoggerFactory.getLogger(ManifestAddon.class);
    private final AddonManifest manifest;
    private final List<AddonInitializer> initializers;
    @Inject
    private Platform platform;

    public ManifestAddon(AddonManifest manifest, List<AddonInitializer> initializers) {
        this.manifest = manifest;
        this.initializers = initializers;
    }

    public AddonManifest getManifest() {
        return this.manifest;
    }

    public String getID() {
        return this.manifest.getID();
    }

    public void initialize() {
        Injector addonInjector = Injector.get((Object)this);
        addonInjector.addExplicitTarget(BaseAddon.class);
        Injector platformInjector = Injector.get((Object)this.platform);
        platformInjector.addExplicitTarget(Platform.class);
        logger.debug("Initializing addon {}", (Object)this.getID());
        this.initializers.forEach(initializer -> {
            Injector loggerInjector = Injector.get((Object)LoggerFactory.getLogger(initializer.getClass()));
            loggerInjector.addExplicitTarget(Logger.class);
            logger.debug("Invoking entry point {}", initializer.getClass());
            addonInjector.inject(initializer);
            platformInjector.inject(initializer);
            loggerInjector.inject(initializer);
            initializer.initialize();
        });
    }

    public Map<String, VersionRange> getDependencies() {
        return this.manifest.getDependencies();
    }

    public Version getVersion() {
        return this.manifest.getVersion();
    }
}

