/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.caffeine.cache;

import me.lucko.luckperms.lib.caffeine.cache.AsyncCacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LocalCacheFactory;
import me.lucko.luckperms.lib.caffeine.cache.Node;
import me.lucko.luckperms.lib.caffeine.cache.Pacer;
import me.lucko.luckperms.lib.caffeine.cache.Scheduler;
import me.lucko.luckperms.lib.caffeine.cache.Ticker;
import me.lucko.luckperms.lib.caffeine.cache.WILMS;
import me.lucko.luckperms.lib.caffeine.cache.WriteOrderDeque;
import org.jspecify.annotations.Nullable;

class WILMSW<K, V>
extends WILMS<K, V> {
    static final LocalCacheFactory FACTORY = WILMSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WILMSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

