/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramCreateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.api.hologram.HologramType;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender sender, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!sender.hasPermission("fancyholograms.hologram.create")) {
            MessageHelper.error(sender, "You don't have the required permission to create a hologram");
            return false;
        }
        if (!(sender instanceof Player)) {
            MessageHelper.error(sender, "You must be a sender to use this command");
            return false;
        }
        Player player = (Player)sender;
        if (args.length < 3) {
            MessageHelper.error((CommandSender)player, "Wrong usage: /hologram help");
            return false;
        }
        HologramType type = HologramType.getByName(args[1]);
        if (type == null) {
            MessageHelper.error((CommandSender)player, "Could not find type: " + args[1]);
            return false;
        }
        String name = args[2];
        if (FancyHolograms.get().getHologramsManager().getHologram(name).isPresent()) {
            MessageHelper.error((CommandSender)player, "There already exists a hologram with this name");
            return false;
        }
        if (name.contains(".")) {
            MessageHelper.error((CommandSender)player, "The name of the hologram cannot contain a dot");
            return false;
        }
        DisplayHologramData displayData = CreateCMD.getDisplayHologramData(player, type, name);
        Hologram holo = FancyHolograms.get().getHologramsManager().create(displayData);
        if (!new HologramCreateEvent(holo, player).callEvent()) {
            MessageHelper.error((CommandSender)player, "Creating the hologram was cancelled");
            return false;
        }
        holo.createHologram();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            holo.updateShownStateFor(onlinePlayer);
        }
        FancyHolograms.get().getHologramsManager().addHologram(holo);
        MessageHelper.success((CommandSender)player, "Created the hologram");
        return true;
    }

    @Nullable
    private static DisplayHologramData getDisplayHologramData(Player player, HologramType type, String name) {
        DisplayHologramData displayData = null;
        switch (type) {
            case TEXT: {
                displayData = new TextHologramData(name, player.getLocation());
                break;
            }
            case ITEM: {
                displayData = new ItemHologramData(name, player.getLocation());
                displayData.setBillboard(Display.Billboard.FIXED);
                break;
            }
            case BLOCK: {
                displayData = new BlockHologramData(name, player.getLocation());
                displayData.setBillboard(Display.Billboard.FIXED);
            }
        }
        return displayData;
    }
}

