/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Color background;
        if (!player.hasPermission("fancyholograms.hologram.edit.background")) {
            MessageHelper.error(player, "You don't have the required permission to chnage the background of a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        String color = args[3].toLowerCase(Locale.ROOT);
        if (color.equals("reset") || color.equals("default")) {
            background = null;
        } else {
            if (color.equals("transparent")) {
                background = Hologram.TRANSPARENT;
            } else if (color.startsWith("#")) {
                Color parsed = Color.fromARGB((int)((int)Long.parseLong(color.substring(1), 16)));
                background = color.length() == 7 ? parsed.setAlpha(255) : parsed;
            } else {
                NamedTextColor named = (NamedTextColor)NamedTextColor.NAMES.value((Object)color.replace(' ', '_'));
                Color color2 = background = named == null ? null : Color.fromARGB((int)(named.value() | 0xC8000000));
            }
            if (background == null) {
                MessageHelper.error(player, "Could not parse background color");
                return false;
            }
        }
        if (Objects.equals(background, textData.getBackground())) {
            MessageHelper.warning(player, "This hologram already has this background color");
            return false;
        }
        TextHologramData copied = textData.copy(textData.getName());
        copied.setBackground(background);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.BACKGROUND)) {
            return false;
        }
        if (Objects.equals(copied.getBackground(), textData.getBackground())) {
            MessageHelper.warning(player, "This hologram already has this background color");
            return false;
        }
        textData.setBackground(copied.getBackground());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Changed background color");
        return true;
    }
}

