/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.api.data;

import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class BlockHologramData
extends DisplayHologramData {
    public static Material DEFAULT_BLOCK = Material.GRASS_BLOCK;
    private Material block = DEFAULT_BLOCK;

    public BlockHologramData(String name, Location location) {
        super(name, HologramType.BLOCK, location);
    }

    public Material getBlock() {
        return this.block;
    }

    public BlockHologramData setBlock(Material block) {
        if (!Objects.equals(this.block, block)) {
            this.block = block;
            this.setHasChanges(true);
        }
        return this;
    }

    @Override
    public boolean read(ConfigurationSection section, String name) {
        super.read(section, name);
        this.block = Material.getMaterial((String)section.getString("block", "GRASS_BLOCK").toUpperCase());
        return true;
    }

    @Override
    public boolean write(ConfigurationSection section, String name) {
        super.write(section, name);
        section.set("block", (Object)this.block.name());
        return true;
    }

    @Override
    public BlockHologramData copy(String name) {
        BlockHologramData blockHologramData = new BlockHologramData(name, this.getLocation());
        blockHologramData.setBlock(this.getBlock()).setScale(this.getScale()).setShadowRadius(this.getShadowRadius()).setShadowStrength(this.getShadowStrength()).setBillboard(this.getBillboard()).setTranslation(this.getTranslation()).setBrightness(this.getBrightness()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
        return blockHologramData;
    }
}

