/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.oliver.fancyanalytics.api.FancyAnalyticsAPI;
import de.oliver.fancyanalytics.api.metrics.MetricSupplier;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancyanalytics.logger.appender.ConsoleAppender;
import de.oliver.fancyanalytics.logger.appender.JsonAppender;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyholograms.FHFeatureFlags;
import de.oliver.fancyholograms.FancyHologramsConfiguration;
import de.oliver.fancyholograms.HologramManagerImpl;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramConfiguration;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.HologramStorage;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.FancyHologramsCMD;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.hologram.version.Hologram1_20_1;
import de.oliver.fancyholograms.hologram.version.Hologram1_20_2;
import de.oliver.fancyholograms.hologram.version.Hologram1_20_4;
import de.oliver.fancyholograms.hologram.version.HologramImpl;
import de.oliver.fancyholograms.listeners.BedrockPlayerListener;
import de.oliver.fancyholograms.listeners.NpcListener;
import de.oliver.fancyholograms.listeners.PlayerListener;
import de.oliver.fancyholograms.listeners.PlayerLoadedListener;
import de.oliver.fancyholograms.listeners.WorldListener;
import de.oliver.fancyholograms.storage.FlatFileHologramStorage;
import de.oliver.fancyholograms.storage.converter.FHConversionRegistry;
import de.oliver.fancyholograms.util.PluginUtils;
import de.oliver.fancylib.FancyLib;
import de.oliver.fancylib.Metrics;
import de.oliver.fancylib.VersionConfig;
import de.oliver.fancylib.logging.PluginMiddleware;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancylib.versionFetcher.MasterVersionFetcher;
import de.oliver.fancylib.versionFetcher.VersionFetcher;
import de.oliver.fancysitula.api.IFancySitula;
import de.oliver.fancysitula.api.utils.ServerVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FancyHolograms
extends JavaPlugin
implements FancyHologramsPlugin {
    @Nullable
    private static FancyHolograms INSTANCE;
    private final ExtendedFancyLogger fancyLogger;
    private final VersionFetcher versionFetcher = new MasterVersionFetcher("FancyHolograms");
    private final VersionConfig versionConfig = new VersionConfig((Plugin)this, this.versionFetcher);
    private final ScheduledExecutorService hologramThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FancyHolograms-Holograms").build());
    private final ExecutorService fileStorageExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setPriority(2).setNameFormat("FancyHolograms-FileStorageExecutor").build());
    private FancyAnalyticsAPI fancyAnalytics;
    private HologramConfiguration configuration = new FancyHologramsConfiguration();
    private HologramStorage hologramStorage = new FlatFileHologramStorage();
    @Nullable
    private HologramManagerImpl hologramsManager;

    public FancyHolograms() {
        INSTANCE = this;
        ConsoleAppender consoleAppender = new ConsoleAppender("[{loggerName}] ({threadName}) {logLevel}: {message}");
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        File logsFile = new File("plugins/FancyHolograms/logs/FH-logs-" + date + ".txt");
        if (!logsFile.exists()) {
            try {
                logsFile.getParentFile().mkdirs();
                logsFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonAppender jsonAppender = new JsonAppender(false, false, true, logsFile.getPath());
        this.fancyLogger = new ExtendedFancyLogger("FancyHolograms", LogLevel.INFO, List.of(consoleAppender, jsonAppender), List.of(new PluginMiddleware((Plugin)this)));
    }

    @NotNull
    public static FancyHolograms get() {
        return Objects.requireNonNull(INSTANCE, "plugin is not initialized");
    }

    public static boolean canGet() {
        return INSTANCE != null;
    }

    public void onLoad() {
        Function<HologramData, Hologram> adapter = this.resolveHologramAdapter();
        if (adapter == null) {
            ArrayList<String> supportedVersions = new ArrayList<String>(List.of("1.20", "1.20.1", "1.20.2", "1.20.3", "1.20.4"));
            supportedVersions.addAll(ServerVersion.getSupportedVersions());
            this.fancyLogger.warn("--------------------------------------------------\nUnsupported minecraft server version.\nPlease update the server to one of (%s).\nDisabling the FancyHolograms plugin.\n--------------------------------------------------\n".formatted(String.join((CharSequence)" / ", supportedVersions)), new Property[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.hologramsManager = new HologramManagerImpl(this, adapter);
        this.fancyLogger.info("Successfully loaded FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onEnable() {
        LogLevel logLevel;
        this.getHologramConfiguration().reload(this);
        new FancyLib(INSTANCE);
        if (!ServerSoftware.isPaper()) {
            this.fancyLogger.warn("--------------------------------------------------\nIt is recommended to use Paper as server software.\nBecause you are not using paper, the plugin\nmight not work correctly.\n--------------------------------------------------\n", new Property[0]);
        }
        try {
            logLevel = LogLevel.valueOf(this.getHologramConfiguration().getLogLevel());
        }
        catch (IllegalArgumentException e) {
            logLevel = LogLevel.INFO;
        }
        this.fancyLogger.setCurrentLevel(logLevel);
        IFancySitula.LOGGER.setCurrentLevel(logLevel);
        FHFeatureFlags.load();
        this.reloadCommands();
        this.registerListeners();
        this.versionConfig.load();
        if (this.getHologramConfiguration().areVersionNotificationsEnabled()) {
            this.checkForNewerVersion();
        }
        this.registerMetrics();
        this.getHologramsManager().initializeTasks();
        if (this.getHologramConfiguration().isAutosaveEnabled()) {
            this.getHologramThread().scheduleAtFixedRate(() -> {
                if (this.hologramsManager != null) {
                    this.hologramsManager.saveHolograms();
                }
            }, this.getHologramConfiguration().getAutosaveInterval(), (long)this.getHologramConfiguration().getAutosaveInterval() * 60L, TimeUnit.SECONDS);
        }
        FHConversionRegistry.registerBuiltInConverters();
        this.fancyLogger.info("Successfully enabled FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onDisable() {
        this.hologramsManager.saveHolograms();
        this.hologramThread.shutdown();
        this.fileStorageExecutor.shutdown();
        INSTANCE = null;
        this.fancyLogger.info("Successfully disabled FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    @Override
    public JavaPlugin getPlugin() {
        return INSTANCE;
    }

    @Override
    public ExtendedFancyLogger getFancyLogger() {
        return this.fancyLogger;
    }

    @NotNull
    public VersionFetcher getVersionFetcher() {
        return this.versionFetcher;
    }

    @NotNull
    public VersionConfig getVersionConfig() {
        return this.versionConfig;
    }

    @ApiStatus.Internal
    @NotNull
    public HologramManagerImpl getHologramsManager() {
        return Objects.requireNonNull(this.hologramsManager, "plugin is not initialized");
    }

    @Override
    public HologramManager getHologramManager() {
        return Objects.requireNonNull(this.hologramsManager, "plugin is not initialized");
    }

    @Override
    public HologramConfiguration getHologramConfiguration() {
        return this.configuration;
    }

    @Override
    public void setHologramConfiguration(HologramConfiguration configuration, boolean reload) {
        this.configuration = configuration;
        if (reload) {
            configuration.reload(this);
            this.reloadCommands();
        }
    }

    @Override
    public HologramStorage getHologramStorage() {
        return this.hologramStorage;
    }

    @Override
    public void setHologramStorage(HologramStorage storage, boolean reload) {
        this.hologramStorage = storage;
        if (reload) {
            this.getHologramsManager().reloadHolograms();
        }
    }

    @Override
    public ScheduledExecutorService getHologramThread() {
        return this.hologramThread;
    }

    public ExecutorService getFileStorageExecutor() {
        return this.fileStorageExecutor;
    }

    @Nullable
    private Function<HologramData, Hologram> resolveHologramAdapter() {
        String version = Bukkit.getMinecraftVersion();
        if (ServerVersion.isVersionSupported(version)) {
            return HologramImpl::new;
        }
        return switch (version) {
            case "1.20.3", "1.20.4" -> Hologram1_20_4::new;
            case "1.20.2" -> Hologram1_20_2::new;
            case "1.20", "1.20.1" -> Hologram1_20_1::new;
            default -> null;
        };
    }

    public void reloadCommands() {
        List<Command> commands = Arrays.asList(new Command[]{new HologramCMD(this), new FancyHologramsCMD(this)});
        if (this.getHologramConfiguration().isRegisterCommands()) {
            commands.forEach(command -> this.getServer().getCommandMap().register("fancyholograms", command));
        } else {
            commands.stream().filter(Command::isRegistered).forEach(command -> command.unregister(this.getServer().getCommandMap()));
        }
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        if (Set.of("1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8").contains(Bukkit.getMinecraftVersion())) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoadedListener(), (Plugin)this);
        }
        if (PluginUtils.isFancyNpcsEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new NpcListener(this), (Plugin)this);
        }
        if (FHFeatureFlags.DISABLE_HOLOGRAMS_FOR_BEDROCK_PLAYERS.isEnabled() && PluginUtils.isFloodgateEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new BedrockPlayerListener(), (Plugin)this);
        }
    }

    private void checkForNewerVersion() {
        ComparableVersion current = new ComparableVersion(this.versionConfig.getVersion());
        ((CompletableFuture)CompletableFuture.supplyAsync(this.getVersionFetcher()::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(current) <= 0) {
                return;
            }
            this.fancyLogger.warn("\n-------------------------------------------------------\nYou are not using the latest version of the FancyHolograms plugin.\nPlease update to the newest version (%s).\n%s\n-------------------------------------------------------\n".formatted(newest, this.getVersionFetcher().getDownloadUrl()), new Property[0]);
        });
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics(this, 17990);
        metrics.addCustomChart(new Metrics.SingleLineChart("total_holograms", () -> this.hologramsManager.getHolograms().size()));
        metrics.addCustomChart(new Metrics.SimplePie("update_notifications", () -> this.configuration.areVersionNotificationsEnabled() ? "Yes" : "No"));
        metrics.addCustomChart(new Metrics.SimplePie("using_development_build", () -> this.versionConfig.isDevelopmentBuild() ? "Yes" : "No"));
        this.fancyAnalytics = new FancyAnalyticsAPI("3b77bd59-2b01-46f2-b3aa-a9584401797f", "E2gW5zc2ZTk1OGFkNGY2ZDQ0ODlM6San");
        this.fancyAnalytics.getConfig().setDisableLogging(true);
        if (!this.versionConfig.isDevelopmentBuild()) {
            return;
        }
        this.fancyAnalytics.registerMinecraftPluginMetrics((Plugin)INSTANCE);
        this.fancyAnalytics.getExceptionHandler().registerLogger(this.getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(Bukkit.getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(this.fancyLogger);
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("commit_hash", () -> this.versionConfig.getCommitHash().substring(0, 7)));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("server_size", () -> {
            long onlinePlayers = Bukkit.getOnlinePlayers().size();
            if (onlinePlayers == 0L) {
                return "empty";
            }
            if (onlinePlayers <= 25L) {
                return "small";
            }
            if (onlinePlayers <= 100L) {
                return "medium";
            }
            if (onlinePlayers <= 500L) {
                return "large";
            }
            return "very_large";
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_holograms", () -> this.hologramsManager.getHolograms().size()));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("enabled_update_notifications", () -> this.configuration.areVersionNotificationsEnabled() ? "true" : "false"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("fflag_disable_holograms_for_bedrock_players", () -> FHFeatureFlags.DISABLE_HOLOGRAMS_FOR_BEDROCK_PLAYERS.isEnabled() ? "true" : "false"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("using_development_build", () -> this.versionConfig.isDevelopmentBuild() ? "true" : "false"));
        this.fancyAnalytics.registerStringArrayMetric(new MetricSupplier<String[]>("hologram_type", () -> {
            if (this.hologramsManager == null) {
                return new String[0];
            }
            return (String[])this.hologramsManager.getHolograms().stream().map(h -> h.getData().getType().name()).toArray(String[]::new);
        }));
        this.fancyAnalytics.initialize();
    }

    public FancyAnalyticsAPI getFancyAnalytics() {
        return this.fancyAnalytics;
    }
}

