/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyanalytics.sdk.logs;

import de.oliver.fancyanalytics.sdk.ApiClient;
import de.oliver.fancyanalytics.sdk.logs.LogRecord;
import java.util.concurrent.ExecutionException;
import java.util.logging.Handler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class JavaLogHandler
extends Handler {
    private final ApiClient apiClient;

    public JavaLogHandler(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void publish(java.util.logging.LogRecord record) {
        block5: {
            LogRecord r = new LogRecord("", record.getLoggerName(), record.getInstant(), record.getLevel().getName(), record.getMessage(), null);
            try {
                Boolean success = this.apiClient.getLogService().createLogRecord("", r).get();
                if (!success.booleanValue() && !this.apiClient.isDisableLogging()) {
                    ApiClient.LOGGER.severe("Failed to publish log record: " + record.getMessage());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (!this.apiClient.isDisableLogging()) {
                    ApiClient.LOGGER.severe("Failed to publish log record: " + e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                if (this.apiClient.isDisableLogging()) break block5;
                ApiClient.LOGGER.warning("Invalid log record: " + e.getMessage());
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

