/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.config;

import com.fancyinnovations.config.ConfigField;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final ExtendedFancyLogger logger;
    private final File configFile;
    private final Map<String, ConfigField<?>> fields;
    private final Map<String, Object> values;

    public Config(ExtendedFancyLogger logger, String configFilePath) {
        this.logger = logger;
        this.configFile = new File(configFilePath);
        this.fields = new ConcurrentHashMap();
        this.values = new ConcurrentHashMap<String, Object>();
    }

    public void addField(ConfigField<?> field) {
        this.fields.put(field.path(), field);
    }

    public Map<String, ConfigField<?>> getFields() {
        return this.fields;
    }

    public <T> T get(String path) {
        ConfigField<?> field = this.fields.get(path);
        if (field == null) {
            return null;
        }
        if (field.forceDefault()) {
            return (T)field.defaultValue();
        }
        Object value = this.values.computeIfAbsent(path, k -> field.defaultValue());
        return (T)field.type().cast(value);
    }

    public void reload() {
        if (!this.configFile.exists()) {
            try {
                if (!this.configFile.createNewFile()) {
                    this.logger.error("Failed to create config file: " + this.configFile.getAbsolutePath(), new Property[0]);
                    return;
                }
            }
            catch (IOException e) {
                this.logger.error("Error creating config file: " + this.configFile.getAbsolutePath(), ThrowableProperty.of(e));
                return;
            }
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.configFile);
            for (ConfigField<?> field : this.fields.values()) {
                this.setDefault(yaml, field);
            }
            this.saveYaml(yaml);
            return;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.configFile);
        boolean dirty = false;
        for (Map.Entry<String, ConfigField<?>> entry : this.fields.entrySet()) {
            String path = entry.getKey();
            ConfigField<?> field = entry.getValue();
            if (field.forRemoval()) {
                if (!yaml.isSet(path)) continue;
                this.logger.debug("Removing path '" + path + "' from config", new Property[0]);
                yaml.set(path, null);
                dirty = true;
                continue;
            }
            if (yaml.isSet(path)) {
                Object value = yaml.get(path);
                if (field.type().isInstance(value)) {
                    this.values.put(path, value);
                    continue;
                }
                this.logger.warn("Value for path '" + path + "' is not of type '" + field.type().getSimpleName(), new Property[0]);
                this.setDefault(yaml, field);
                dirty = true;
                continue;
            }
            this.logger.debug("Path '" + path + "' not found in config", new Property[0]);
            this.setDefault(yaml, field);
            dirty = true;
        }
        if (dirty) {
            this.saveYaml(yaml);
        }
    }

    private void setDefault(YamlConfiguration yaml, ConfigField<?> field) {
        this.logger.debug("Setting default value for path '" + field.path() + "': " + String.valueOf(field.defaultValue()), new Property[0]);
        yaml.set(field.path(), field.defaultValue());
        yaml.setInlineComments(field.path(), List.of(field.description()));
    }

    private void saveYaml(YamlConfiguration yaml) {
        try {
            yaml.save(this.configFile);
        }
        catch (IOException e) {
            this.logger.error("Error saving config file: " + this.configFile.getAbsolutePath(), ThrowableProperty.of(e));
        }
    }
}

