/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class UUIDUtils {
    public static Optional<UUID> tryParseUniqueId(String str) {
        try {
            return Optional.of(UUID.fromString(str));
        }
        catch (IllegalArgumentException ignored) {
            if (str.length() == 32) {
                try {
                    return Optional.of(UUIDUtils.convertToDashed(str));
                }
                catch (IllegalArgumentException ignored2) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    }

    @Nullable
    public static UUID parseUniqueIdNullable(String str) {
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static UUID convertToDashed(String noDashes) {
        StringBuilder idBuff = new StringBuilder(noDashes);
        idBuff.insert(20, '-');
        idBuff.insert(16, '-');
        idBuff.insert(12, '-');
        idBuff.insert(8, '-');
        return UUID.fromString(idBuff.toString());
    }

    public static String convertToNoDashes(UUID uuid) {
        return uuid.toString().replace("-", "");
    }
}

