/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.skinsrestorer.api.Base64Utils;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.InjectorBuilder;
import net.skinsrestorer.shadow.injector.handlers.dependency.CyclicDependenciesDetector;
import net.skinsrestorer.shadow.injector.handlers.dependency.FactoryDependencyHandler;
import net.skinsrestorer.shadow.injector.handlers.dependency.SavedAnnotationsHandler;
import net.skinsrestorer.shadow.injector.handlers.dependency.SingletonStoreDependencyHandler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.DefaultInjectionProvider;
import net.skinsrestorer.shadow.injector.handlers.instantiation.ProviderHandler;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j18.stub.java_base.J_L_System;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.ValidationUtil;
import xyz.wagyourtail.jvmdg.version.Stub;

public class SRHelpers {
    public static final String MESSAGE_CHANNEL = "sr:messagechannel";
    private static final String NAMEMC_IMG_URL = "https://s.namemc.com/i/%s.png";
    public static final String DOWNLOAD_URL = "https://modrinth.com/plugin/skinsrestorer";

    private SRHelpers() {
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return SRHelpers.getRootCause(throwable.getCause());
        }
        return throwable;
    }

    public static byte[] hashSHA256ToBytes(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static long hashSha256ToLong(byte[] bytes) {
        return ByteBuffer.wrap(SRHelpers.hashSHA256ToBytes(bytes)).getLong();
    }

    public static long hashSha256ToLong(String str) {
        return SRHelpers.hashSha256ToLong(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String hashSha256ToHex(byte[] bytes) {
        return SRHelpers.bytesToHex(SRHelpers.hashSHA256ToBytes(bytes));
    }

    public static String hashSha256ToHex(String str) {
        return SRHelpers.hashSha256ToHex(str.getBytes(StandardCharsets.UTF_8));
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static long getEpochSecond() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public static void renameFile(Path parent, String oldName, String newName) throws IOException {
        try (Stream<Path> stream = Files.list(parent);){
            List<String> files = J_U_S_Stream.toList(stream.map(Path::getFileName).map(Path::toString));
            String tempName = J_L_String.formatted("%s_temp", newName);
            if (files.contains(oldName) && !files.contains(tempName) && !files.contains(newName)) {
                Path oldPath = parent.resolve(oldName);
                Path tempPath = parent.resolve(tempName);
                Path newPath = parent.resolve(newName);
                Files.move(oldPath, tempPath, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tempPath, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static <E> E getRandomEntry(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E getRandomEntry(Collection<E> list) {
        int index = ThreadLocalRandom.current().nextInt(list.size());
        int i = 0;
        for (E entry : list) {
            if (i == index) {
                return entry;
            }
            ++i;
        }
        throw new IllegalStateException("Failed to get random entry");
    }

    public static int getJavaVersion() {
        String majorVersion;
        String specVersion = J_L_System.getProperty("java.specification.version");
        String[] split = specVersion.split("\\.");
        if (split.length == 0 || split.length > 2) {
            throw new IllegalArgumentException(J_L_String.formatted("Invalid Java version: %s", specVersion));
        }
        if (split.length == 1) {
            majorVersion = split[0];
        } else if (split[0].equals("1")) {
            majorVersion = split[1];
        } else {
            throw new IllegalArgumentException(J_L_String.formatted("Invalid Java version: %s", specVersion));
        }
        return Integer.parseInt(majorVersion);
    }

    public static Optional<URL> parseURL(String str) {
        try {
            return Optional.of(URI.create(str).toURL());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String sanitizeImageURL(String imageUrl) {
        boolean isNamemc;
        Optional<URL> uriOptional = SRHelpers.parseURL(imageUrl);
        if (J_U_Optional.isEmpty(uriOptional)) {
            return imageUrl;
        }
        String host = uriOptional.get().getHost();
        if (host == null) {
            return imageUrl;
        }
        boolean bl = isNamemc = host.equals("namemc.com") || host.endsWith(".namemc.com");
        if (isNamemc) {
            String path = uriOptional.get().getPath();
            if (path == null) {
                return imageUrl;
            }
            String skinPath = "/skin/";
            if (path.startsWith(skinPath)) {
                String uuid = path.substring(skinPath.length());
                return J_L_String.formatted(NAMEMC_IMG_URL, uuid);
            }
        }
        return imageUrl;
    }

    public static String sanitizeSkinInput(String skinInput) {
        String profilePath;
        String path;
        boolean isNamemc;
        Optional<URL> uriOptional = SRHelpers.parseURL(skinInput);
        if (J_U_Optional.isEmpty(uriOptional)) {
            return skinInput;
        }
        String host = uriOptional.get().getHost();
        if (host == null) {
            return skinInput;
        }
        boolean bl = isNamemc = host.equals("namemc.com") || host.endsWith(".namemc.com");
        if (isNamemc && (path = uriOptional.get().getPath()).startsWith(profilePath = "/profile/")) {
            String usernamePart = path.substring(profilePath.length());
            int dotIndex = usernamePart.indexOf(46);
            if (dotIndex != -1) {
                usernamePart = usernamePart.substring(0, dotIndex);
            }
            if (ValidationUtil.validSkinUrl(usernamePart)) {
                return usernamePart;
            }
        }
        return skinInput;
    }

    public static String formatEpochSeconds(SettingsManager settings, long epochSeconds, Locale locale) {
        return SRHelpers.formatEpochMillis(settings, TimeUnit.SECONDS.toMillis(epochSeconds), locale);
    }

    public static String formatEpochMillis(SettingsManager settings, long epochMillis, Locale locale) {
        return new SimpleDateFormat(settings.getProperty(MessageConfig.DATE_FORMAT), locale).format(new Date(epochMillis));
    }

    public static <E extends Enum<E>, V> Map<E, V> suppliedMap(Class<E> clazz, Function<E, V> mapper) {
        EnumMap<E, V> map = new EnumMap<E, V>(clazz);
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            map.put((E)e, mapper.apply(e));
        }
        return map;
    }

    public static String durationFormat(SkinsRestorerLocale locale, SRCommandSender sender, Duration duration) {
        if (duration.isNegative() || duration.isZero() || duration.getSeconds() == 0L) {
            duration = Duration.ofSeconds(1L);
        }
        long days = duration.toDays();
        long hours = SRHelpers.jvmdg$inlined$toHoursPart(duration);
        long minutes = SRHelpers.jvmdg$inlined$toMinutesPart(duration);
        long seconds = SRHelpers.jvmdg$inlined$toSecondsPart(duration);
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days).append(ComponentHelper.convertJsonToPlain(locale.getMessageRequired(sender, days == 1L ? Message.DURATION_DAY : Message.DURATION_DAYS))).append(" ");
        }
        if (hours > 0L) {
            result.append(hours).append(ComponentHelper.convertJsonToPlain(locale.getMessageRequired(sender, hours == 1L ? Message.DURATION_HOUR : Message.DURATION_HOURS))).append(" ");
        }
        if (minutes > 0L) {
            result.append(minutes).append(ComponentHelper.convertJsonToPlain(locale.getMessageRequired(sender, minutes == 1L ? Message.DURATION_MINUTE : Message.DURATION_MINUTES))).append(" ");
        }
        if (seconds > 0L || SRHelpers.jvmdg$inlined$isEmpty(result)) {
            result.append(seconds).append(ComponentHelper.convertJsonToPlain(locale.getMessageRequired(sender, seconds == 1L ? Message.DURATION_SECOND : Message.DURATION_SECONDS))).append(" ");
        }
        return result.toString().trim();
    }

    public static String encodeHashToTexturesValue(String textureHash) {
        return Base64Utils.encode(J_L_String.formatted("{\"textures\":{\"SKIN\":{\"url\":\"https://textures.minecraft.net/texture/%s\"}}}", textureHash));
    }

    public static void createDirectoriesSafe(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(J_L_String.formatted("Failed to create directories: %s", path), e);
            }
        }
    }

    public static void writeIfNeeded(Path path, String content) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            String existingContent = J_N_F_Files.readString(path);
            if (!existingContent.equals(content)) {
                J_N_F_Files.writeString(path, (CharSequence)content, new OpenOption[0]);
            }
        } else {
            SRHelpers.createDirectoriesSafe(path.getParent());
            J_N_F_Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
    }

    public static void mustSupply(Supplier<Runnable> supplier) {
        supplier.get().run();
    }

    public static Injector createInjector() {
        return new InjectorBuilder().addHandlers(new SavedAnnotationsHandler(), new ProviderHandler(), new FactoryDependencyHandler(), new SingletonStoreDependencyHandler(), new CyclicDependenciesDetector(), new DefaultInjectionProvider("net.skinsrestorer")).create();
    }

    @Stub(excludeChild={"java/lang/String"})
    private static /* synthetic */ boolean jvmdg$inlined$isEmpty(CharSequence cs) {
        return cs.length() == 0;
    }

    @Stub
    private static /* synthetic */ int jvmdg$inlined$toMinutesPart(Duration self) {
        return (int)(self.toMinutes() % 60L);
    }

    @Stub
    private static /* synthetic */ int jvmdg$inlined$toHoursPart(Duration self) {
        return (int)(self.toHours() % 24L);
    }

    @Stub
    private static /* synthetic */ int jvmdg$inlined$toSecondsPart(Duration self) {
        return (int)(self.getSeconds() % 60L);
    }
}

