/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;

public class ProxyAckTracker {
    private final SRLogger logger;
    private final SRPlatformAdapter adapter;
    private final Set<String> verifiedServers = Collections.synchronizedSet(new HashSet());
    private final Set<String> brokenServers = Collections.synchronizedSet(new HashSet());
    private final Map<String, Integer> serverNackCounts = new ConcurrentHashMap<String, Integer>();

    public Optional<SRServerPluginMessage.SkinUpdateV3ChannelPayload.AckPayload> shouldAckPayload(SRProxyPlayer player) {
        Optional<String> optionalServer = player.getCurrentServer();
        if (J_U_Optional.isEmpty(optionalServer)) {
            return Optional.empty();
        }
        String server = optionalServer.get();
        if (this.verifiedServers.contains(server)) {
            this.logger.debug(J_L_String.formatted("Backend server '%s' already verified. Skipping ACK payload.", server));
            return Optional.empty();
        }
        UUID ackId = UUID.randomUUID();
        this.logger.debug(J_L_String.formatted("Sending ACK payload to player '%s' with ACK id %s to backend server '%s'", player.getName(), ackId, server));
        this.adapter.runAsyncDelayed(() -> this.handleProxyServerState(server), 30L, TimeUnit.SECONDS);
        return Optional.of(new SRServerPluginMessage.SkinUpdateV3ChannelPayload.AckPayload(ackId, BuildData.VERSION));
    }

    private void handleProxyServerState(String server) {
        if (this.verifiedServers.contains(server)) {
            this.logger.debug(J_L_String.formatted("Backend server '%s' is already verified, skipping state check.", server));
        } else if (this.brokenServers.contains(server)) {
            this.logger.debug(J_L_String.formatted("Backend server '%s' is already marked as broken, skipping state check.", server));
        } else if (this.serverNackCounts.compute(server, (key, count) -> count == null ? 1 : count + 1) >= 3) {
            this.logger.warning(J_L_String.formatted("Backend server '%s' does likely not have SkinsRestorer installed or is not responding to ACK messages. Please make sure that the server has SkinsRestorer installed and is running the latest version. %s", server, "https://modrinth.com/plugin/skinsrestorer"));
            this.brokenServers.add(server);
            this.serverNackCounts.remove(server);
        } else {
            this.logger.debug(J_L_String.formatted("Backend server '%s' did not respond to ACK message in time. This may indicate that the server is not running SkinsRestorer or is not responding to ACK messages.", server));
        }
    }

    public void receivedAck(SRProxyPlayer player, UUID ackId, String serverSrVersion) {
        this.logger.debug(J_L_String.formatted("Received ACK from player '%s' with ACK id %s", player.getName(), ackId));
        Optional<String> optionalServer = player.getCurrentServer();
        if (J_U_Optional.isEmpty(optionalServer)) {
            return;
        }
        String server = optionalServer.get();
        if (!this.verifiedServers.add(server)) {
            this.logger.debug(J_L_String.formatted("Backend server '%s' already verified. Skipping version check.", server));
            return;
        }
        if (serverSrVersion.equalsIgnoreCase(BuildData.VERSION)) {
            this.logger.debug(J_L_String.formatted("Backend server '%s' is verified with SkinsRestorer version %s.", server, serverSrVersion));
        } else {
            this.logger.warning(J_L_String.formatted("Backend server '%s' is running a different version of SkinsRestorer (%s) than this proxy (%s). Make sure both server and proxy run the latest version of SkinsRestorer. %s", server, serverSrVersion, BuildData.VERSION, "https://modrinth.com/plugin/skinsrestorer"));
        }
    }

    @Inject
    @Generated
    public ProxyAckTracker(SRLogger logger, SRPlatformAdapter adapter) {
        this.logger = logger;
        this.adapter = adapter;
    }
}

