/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.update.DownloaderClassProvider;
import net.skinsrestorer.shared.update.UpdateCause;
import net.skinsrestorer.shared.update.UpdateCheckExecutor;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.update.UpdateDownloader;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={InitCause.class})
public class UpdateCheckInit {
    private final SRPlugin plugin;
    private final SRLogger logger;
    private final SRPlatformAdapter adapter;
    private final UpdateCheckerGitHub updateChecker;
    private final UpdateCheckExecutor updateCheckExecutor;
    private final Injector injector;

    public Optional<UpdateDownloader> getDownloader() {
        DownloaderClassProvider downloaderClassProvider;
        boolean downloaderDisabled;
        boolean bl = downloaderDisabled = Files.exists(this.plugin.getDataFolder().resolve("noautoupdate.txt"), new LinkOption[0]) || Files.exists(this.plugin.getDataFolder().resolve("noupdate.txt"), new LinkOption[0]);
        if (downloaderDisabled) {
            this.logger.info("Auto updater was manually disabled. This is not recommended, as it will prevent the plugin from updating automatically. See why at: https://skinsrestorer.net/docs/configuration/auto-update");
        }
        return (downloaderClassProvider = this.injector.getIfAvailable(DownloaderClassProvider.class)) == null || downloaderDisabled ? Optional.empty() : Optional.of((UpdateDownloader)this.injector.getSingleton((Class)downloaderClassProvider.get()));
    }

    public void run(InitCause cause) {
        UpdateDownloader downloader = this.getDownloader().orElse(null);
        this.updateCheckExecutor.checkUpdate(cause.toUpdateCause(), this.updateChecker, downloader, true);
        int delayInt = 60 + ThreadLocalRandom.current().nextInt(181);
        this.adapter.runRepeatAsync(() -> this.updateCheckExecutor.checkUpdate(UpdateCause.SCHEDULED, this.updateChecker, downloader, false), delayInt, delayInt, TimeUnit.MINUTES);
    }

    @Inject
    @Generated
    public UpdateCheckInit(SRPlugin plugin, SRLogger logger, SRPlatformAdapter adapter, UpdateCheckerGitHub updateChecker, UpdateCheckExecutor updateCheckExecutor, Injector injector) {
        this.plugin = plugin;
        this.logger = logger;
        this.adapter = adapter;
        this.updateChecker = updateChecker;
        this.updateCheckExecutor = updateCheckExecutor;
        this.injector = injector;
    }

    @NestHost(value=UpdateCheckInit.class)
    public static enum InitCause {
        STARTUP,
        ERROR;


        public UpdateCause toUpdateCause() {
            return this == STARTUP ? UpdateCause.STARTUP : UpdateCause.ERROR;
        }
    }
}

