/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.permissions;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ValidationUtil;

public class SkinPermissionManager {
    private final SettingsManager settings;

    public Optional<Message> canSetSkin(SRCommandSender sender, String skinInput) {
        SRPlayer player;
        if (!(!this.isPerSkinPermissions() || sender.hasPermission(PermissionRegistry.forSkin(skinInput.toLowerCase(Locale.ROOT))) || sender.hasPermission(PermissionRegistry.OWN_SKIN) && sender instanceof SRPlayer && skinInput.equalsIgnoreCase((player = (SRPlayer)sender).getName()))) {
            return Optional.of(Message.PLAYER_HAS_NO_PERMISSION_SKIN);
        }
        if (this.isDisabledSkin(skinInput) && !sender.hasPermission(PermissionRegistry.BYPASS_DISABLED)) {
            return Optional.of(Message.ERROR_SKIN_DISABLED);
        }
        if (ValidationUtil.validSkinUrl(skinInput)) {
            if (!sender.hasPermission(PermissionRegistry.SKIN_SET_URL)) {
                return Optional.of(Message.PLAYER_HAS_NO_PERMISSION_URL);
            }
            if (!this.allowedSkinUrl(skinInput)) {
                return Optional.of(Message.ERROR_SKINURL_DISALLOWED);
            }
        }
        return Optional.empty();
    }

    private boolean isPerSkinPermissions() {
        if (this.settings.getProperty(CommandConfig.PER_SKIN_PERMISSIONS).booleanValue()) {
            return this.settings.getProperty(CommandConfig.PER_SKIN_PERMISSIONS_CONSENT).equalsIgnoreCase("I will follow the rules");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDisabledSkin(String skinName) {
        if (this.settings.getProperty(CommandConfig.DISABLED_SKINS_ENABLED) == false) return false;
        if (!this.settings.getProperty(CommandConfig.DISABLED_SKINS).stream().anyMatch(skinName::equalsIgnoreCase)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean allowedSkinUrl(String url) {
        if (this.settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED) == false) return true;
        if (!this.settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_LIST).stream().anyMatch(url::startsWith)) return false;
        return true;
    }

    @Inject
    @Generated
    public SkinPermissionManager(SettingsManager settings) {
        this.settings = settings;
    }
}

