/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.permissions;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;

public enum PermissionGroup {
    PLAYER(Permission.of("skinsrestorer.player"), Permission.of("skinsrestorer.command.*"), Message.PERMISSION_PLAYER_WILDCARD, PermissionRegistry.SKIN, PermissionRegistry.SKIN_SET, PermissionRegistry.SKIN_SET_URL, PermissionRegistry.SKIN_CLEAR, PermissionRegistry.SKIN_UNDO, PermissionRegistry.SKIN_FAVOURITE, PermissionRegistry.SKIN_RANDOM, PermissionRegistry.SKIN_UPDATE, PermissionRegistry.SKIN_SEARCH, PermissionRegistry.SKIN_EDIT, PermissionRegistry.SKINS),
    ADMIN(Permission.of("skinsrestorer.admin"), Permission.of("skinsrestorer.admincommand.*"), Message.PERMISSION_ADMIN_WILDCARD, new PermissionGroup[]{PLAYER}, PermissionRegistry.SR, PermissionRegistry.SKIN_SET_OTHER, PermissionRegistry.SKIN_CLEAR_OTHER, PermissionRegistry.SKIN_UNDO_OTHER, PermissionRegistry.SKIN_FAVOURITE_OTHER, PermissionRegistry.SKIN_RANDOM_OTHER, PermissionRegistry.SKIN_UPDATE_OTHER, PermissionRegistry.SR_STATUS, PermissionRegistry.SR_DROP, PermissionRegistry.SR_INFO, PermissionRegistry.SR_APPLY_SKIN, PermissionRegistry.SR_CREATE_CUSTOM, PermissionRegistry.SKULL_GET, PermissionRegistry.SKULL_GET_OTHER, PermissionRegistry.SKULL_GET_URL, PermissionRegistry.SKULL_RANDOM, PermissionRegistry.SKULL_RANDOM_OTHER, PermissionRegistry.BYPASS_COOLDOWN, PermissionRegistry.BYPASS_DISABLED);

    public static final PermissionGroup[] VALUES;
    public static final PermissionGroup DEFAULT_GROUP;
    private final Permission basePermission;
    private final Permission wildcard;
    private final Message description;
    private final PermissionGroup[] parents;
    private final PermissionRegistry[] permissions;

    private PermissionGroup(Permission basePermission, Permission wildcard, Message description, PermissionRegistry ... permissions) {
        this(basePermission, wildcard, description, new PermissionGroup[0], permissions);
    }

    private PermissionGroup(Permission basePermission, Permission wildcard, Message description, PermissionGroup[] parents, PermissionRegistry ... permissions) {
        this.basePermission = basePermission;
        this.wildcard = wildcard;
        this.description = description;
        this.parents = parents;
        this.permissions = permissions;
    }

    public static Collection<PermissionGroup> getGrantedBy(Permission permission) {
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>();
        for (PermissionGroup group : VALUES) {
            if (!group.hasPermission(permission)) continue;
            groups.add(group);
        }
        return groups;
    }

    public boolean hasPermission(Permission permission) {
        for (PermissionRegistry permissionRegistry : this.permissions) {
            if (!permissionRegistry.getPermission().equals(permission)) continue;
            return true;
        }
        for (Enum enum_ : this.parents) {
            if (!((PermissionGroup)enum_).hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public Permission getBasePermission() {
        return this.basePermission;
    }

    @Generated
    public Permission getWildcard() {
        return this.wildcard;
    }

    @Generated
    public Message getDescription() {
        return this.description;
    }

    @Generated
    public PermissionGroup[] getParents() {
        return this.parents;
    }

    @Generated
    public PermissionRegistry[] getPermissions() {
        return this.permissions;
    }

    static {
        VALUES = PermissionGroup.values();
        DEFAULT_GROUP = PLAYER;
    }
}

