/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.errorprone.annotations.RestrictedApi;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.MiniMessage;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.subjects.messages.LocaleManager;
import net.skinsrestorer.shared.subjects.messages.Message;

public class SkinsRestorerLocale {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final SRForeign englishForeign = () -> Locale.ENGLISH;
    @Inject
    private LocaleManager localeManager;
    @Inject
    private SettingsManager settings;
    private final SRForeign defaultForeign = () -> this.settings.getProperty(MessageConfig.LOCALE);

    public ComponentString getMessageRequired(SRForeign foreign, Message key) {
        return this.getMessageRequired(foreign, key, TagResolver.empty());
    }

    @RestrictedApi(explanation="The method signature changes after relocation, so it shall only be used within this package", allowedOnPath=".*net/skinsrestorer/shared/.*")
    public ComponentString getMessageRequired(SRForeign foreign, Message key, TagResolver ... tagResolver) {
        return ComponentHelper.convertComponentToJson(this.getMessageInternal(foreign, key, TagResolver.resolver(tagResolver)).orElseGet(Component::empty));
    }

    public Optional<ComponentString> getMessageOptional(SRForeign foreign, Message key) {
        return this.getMessageOptional(foreign, key, TagResolver.empty());
    }

    @RestrictedApi(explanation="The method signature changes after relocation, so it shall only be used within this package", allowedOnPath=".*net/skinsrestorer/shared/.*")
    public Optional<ComponentString> getMessageOptional(SRForeign foreign, Message key, TagResolver ... tagResolver) {
        return this.getMessageInternal(foreign, key, TagResolver.resolver(tagResolver)).map(ComponentHelper::convertComponentToJson);
    }

    private Optional<Component> getMessageInternal(SRForeign foreign, Message key, TagResolver tagResolver) {
        String message = this.localeManager.getMessage(foreign.getLocale(), key);
        if (message == null) {
            throw new IllegalStateException(J_L_String.formatted("Message %s not found", key.name()));
        }
        if (message.isEmpty()) {
            return Optional.empty();
        }
        Component component = this.miniMessage.deserialize(message, tagResolver);
        Message parent = key.getParent();
        if (!(parent == null || parent == Message.PREFIX_FORMAT && this.settings.getProperty(MessageConfig.DISABLE_PREFIX).booleanValue())) {
            return this.getMessageInternal(foreign, parent, TagResolver.resolver(tagResolver, Placeholder.component("message", component)));
        }
        return Optional.of(component);
    }

    @Generated
    public SRForeign getEnglishForeign() {
        return this.englishForeign;
    }

    @Generated
    public SRForeign getDefaultForeign() {
        return this.defaultForeign;
    }
}

