/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.skin;

import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;

public class URLSkinFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private String url;
    private String mineSkinId;
    private String value;
    private String signature;
    private SkinVariant skinVariant;
    private int dataVersion;

    public static URLSkinFile fromURLSkinData(URLSkinData urlSkinData) {
        URLSkinFile urlSkinFile = new URLSkinFile();
        urlSkinFile.url = urlSkinData.getUrl();
        urlSkinFile.mineSkinId = urlSkinData.getMineSkinId();
        urlSkinFile.value = urlSkinData.getProperty().getValue();
        urlSkinFile.signature = urlSkinData.getProperty().getSignature();
        urlSkinFile.skinVariant = urlSkinData.getSkinVariant();
        urlSkinFile.dataVersion = 1;
        return urlSkinFile;
    }

    public URLSkinData toURLSkinData() {
        return URLSkinData.of(this.url, this.mineSkinId, SkinProperty.of(this.value, this.signature), this.skinVariant);
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getMineSkinId() {
        return this.mineSkinId;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public SkinVariant getSkinVariant() {
        return this.skinVariant;
    }

    @Generated
    public int getDataVersion() {
        return this.dataVersion;
    }

    @Generated
    public URLSkinFile() {
    }
}

